/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.carbon;

import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigSection;
import carbonconfiglib.gui.api.IConfigFolderNode;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.impl.carbon.ConfigLeaf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ConfigNode
implements IConfigFolderNode {
    ConfigSection section;
    List<IConfigNode> children;

    public ConfigNode(ConfigSection section) {
        this.section = section;
    }

    @Override
    public List<IConfigNode> getChildren() {
        if (this.children == null) {
            this.children = new ObjectArrayList();
            for (ConfigSection configSection : this.section.getChildren()) {
                this.children.add(new ConfigNode(configSection));
            }
            for (ConfigEntry configEntry : this.section.getEntries()) {
                this.children.add(new ConfigLeaf(configEntry));
            }
        }
        return this.children;
    }

    @Override
    public String getNodeName() {
        return this.section.getName().toLowerCase(Locale.ROOT);
    }

    @Override
    public Component getName() {
        return IConfigNode.createLabel(this.section.getName());
    }

    @Override
    public Component getTooltip() {
        MutableComponent comp = Component.empty();
        comp.append((Component)Component.literal((String)this.section.getName()).withStyle(ChatFormatting.YELLOW));
        String[] array = this.section.getComment();
        if (array != null && array.length > 0) {
            int i = 0;
            while (i < array.length) {
                comp.append("\n").append(array[i++]).withStyle(ChatFormatting.GRAY);
            }
        }
        return comp;
    }
}

