/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.widgets.CarbonButton;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class MultiChoiceScreen
extends Screen {
    private final Component message;
    private MultiLineLabel multilineMessage = MultiLineLabel.EMPTY;
    protected Component mainButton;
    protected Component otherButton;
    protected Component cancelButton;
    protected final Consumer<Result> callback;

    public MultiChoiceScreen(Consumer<Result> callback, Component title, Component message, Component mainButton) {
        this(callback, title, message, mainButton, null, null);
    }

    public MultiChoiceScreen(Consumer<Result> callback, Component title, Component message, Component mainButton, Component otherButton, Component cancelButton) {
        super(title);
        this.callback = callback;
        this.message = message;
        this.mainButton = mainButton;
        this.otherButton = otherButton;
        this.cancelButton = cancelButton;
    }

    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration((Component[])new Component[]{super.getNarrationMessage(), this.message});
    }

    protected void init() {
        super.init();
        this.multilineMessage = MultiLineLabel.create((Font)this.font, (FormattedText)this.message, (int)(this.width - 50));
        this.addButtons(Mth.clamp((int)(this.messageTop() + this.messageHeight() + 20), (int)(this.height / 6 + 96), (int)(this.height - 24)));
    }

    protected void addButtons(int y) {
        boolean singleOption = this.otherButton == null && this.cancelButton == null;
        this.addRenderableWidget((GuiEventListener)new CarbonButton(this.width / 2 - 50 - (singleOption ? 50 : 105), y, singleOption ? 200 : 100, 20, this.mainButton, T -> this.callback.accept(Result.MAIN)));
        if (singleOption) {
            return;
        }
        this.addRenderableWidget((GuiEventListener)new CarbonButton(this.width / 2 - 50, y, 100, 20, this.otherButton, T -> this.callback.accept(Result.OTHER)));
        this.addRenderableWidget((GuiEventListener)new CarbonButton(this.width / 2 - 50 + 105, y, 100, 20, this.cancelButton, T -> this.callback.accept(Result.CANCEL)));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, this.titleTop(), 0xFFFFFF);
        this.multilineMessage.renderCentered(graphics, this.width / 2, this.messageTop());
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    private int titleTop() {
        int i = (this.height - this.messageHeight()) / 2;
        return Mth.clamp((int)(i - 20 - 9), (int)10, (int)80);
    }

    private int messageTop() {
        return this.titleTop() + 20;
    }

    private int messageHeight() {
        return this.multilineMessage.getLineCount() * 9;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean keyPressed(int mouseButton, int mouseX, int mouseY) {
        if (mouseButton == 256) {
            this.callback.accept(Result.CANCEL);
            return true;
        }
        return super.keyPressed(mouseButton, mouseX, mouseY);
    }

    public static enum Result {
        MAIN,
        OTHER,
        CANCEL;


        public boolean isCancel() {
            return this == CANCEL;
        }

        public boolean isMain() {
            return this == MAIN;
        }

        public boolean isOther() {
            return this == OTHER;
        }
    }
}

