/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.widgets;

import carbonconfiglib.gui.config.IListOwner;
import carbonconfiglib.gui.widgets.GuiUtils;
import carbonconfiglib.gui.widgets.Icon;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CarbonIconCheckbox
extends AbstractButton {
    private static final ResourceLocation CHECKBOX_HIGHLIGHTED_SPRITE = new ResourceLocation("widget/checkbox_highlighted");
    private static final ResourceLocation CHECKBOX_SPRITE = new ResourceLocation("widget/checkbox");
    private boolean selected;
    Icon selectedIcon;
    Icon unselectedIcon;
    Runnable listener;
    Component tooltip;
    IListOwner owner;

    public CarbonIconCheckbox(int x, int y, int width, int height, Icon selectedIcon, Icon unselectedIcon, boolean selected) {
        super(x, y, width, height, (Component)Component.empty());
        this.selectedIcon = selectedIcon;
        this.unselectedIcon = unselectedIcon;
        this.selected = selected;
    }

    public CarbonIconCheckbox withListener(Runnable listener) {
        this.listener = listener;
        return this;
    }

    public CarbonIconCheckbox setTooltip(IListOwner owner, String tooltips) {
        this.owner = owner;
        this.tooltip = Component.translatable((String)tooltips);
        return this;
    }

    public void onPress() {
        boolean bl = this.selected = !this.selected;
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public void setSelected(boolean value) {
        this.selected = value;
    }

    public boolean selected() {
        return this.selected;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        graphics.blitSprite(this.isHoveredOrFocused() ? CHECKBOX_HIGHLIGHTED_SPRITE : CHECKBOX_SPRITE, this.getX(), this.getY(), this.width, this.height);
        GuiUtils.drawTextureRegion(graphics, this.getX() + 2, this.getY() + 2, this.width - 4, this.height - 4, this.selected ? this.selectedIcon : this.unselectedIcon, 16.0f, 16.0f);
        if (this.owner != null && this.isMouseOver(mouseX, mouseY)) {
            this.owner.addTooltips(this.tooltip);
        }
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (!this.active) {
            return;
        }
        output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)(this.isFocused() ? "narration.checkbox.usage.hovered" : "narration.checkbox.usage.focused")));
    }
}

