/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.impl.internal;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.IConfigChangeListener;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.IModConfigs;
import carbonconfiglib.gui.api.ISuggestionRenderer;
import carbonconfiglib.gui.config.ColorElement;
import carbonconfiglib.gui.config.RegistryElement;
import carbonconfiglib.gui.impl.forge.ForgeConfigs;
import carbonconfiglib.gui.impl.minecraft.MinecraftConfigs;
import carbonconfiglib.gui.screen.ConfigSelectorScreen;
import carbonconfiglib.gui.widgets.SuggestionRenderers;
import carbonconfiglib.impl.PerWorldProxy;
import carbonconfiglib.impl.entries.ColorValue;
import carbonconfiglib.impl.internal.ModConfigList;
import carbonconfiglib.impl.internal.ModConfigs;
import carbonconfiglib.networking.carbon.StateSyncPacket;
import carbonconfiglib.networking.snyc.BulkSyncPacket;
import carbonconfiglib.networking.snyc.SyncPacket;
import carbonconfiglib.utils.SyncType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.mclanguageprovider.MinecraftModContainer;
import net.neoforged.neoforge.client.ConfigScreenHandler;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectLinkedOpenHashMap;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;

public class EventHandler
implements IConfigChangeListener {
    public static final EventHandler INSTANCE = new EventHandler();
    Map<ModContainer, ModConfigs> configs = new Object2ObjectLinkedOpenHashMap().synchronize();

    @Override
    public void onConfigCreated(ConfigHandler config) {
        this.initMinecraftDataTypes(config);
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return;
        }
        ModLoadingContext context = ModLoadingContext.get();
        if ("minecraft".equals(context.getActiveNamespace())) {
            if (FMLEnvironment.production) {
                return;
            }
            throw new IllegalStateException("Mod Configs Must be created (not loaded) during a Mod Loading Phase");
        }
        this.configs.computeIfAbsent(context.getActiveContainer(), ModConfigs::new).addConfig(config);
    }

    public void initMinecraftDataTypes(ConfigHandler config) {
        config.addParser('C', ColorValue::parse);
        config.addTempParser('R');
        config.addTempParser('K');
    }

    @Override
    public void onConfigAdded(ConfigHandler config) {
    }

    @Override
    public void onConfigChanged(ConfigHandler config) {
        SyncPacket packet;
        if (FMLEnvironment.dist.isDedicatedServer()) {
            SyncPacket packet2 = SyncPacket.create(config, SyncType.SERVER_TO_CLIENT, false);
            if (packet2 != null) {
                CarbonConfig.NETWORK.sendToAllPlayers(packet2);
            }
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (packet = SyncPacket.create(config, SyncType.SERVER_TO_CLIENT, false)) != null) {
            CarbonConfig.NETWORK.sendToAllPlayers(packet);
        }
        if (CarbonConfig.NETWORK.isInWorld() && (packet = SyncPacket.create(config, SyncType.CLIENT_TO_SERVER, false)) != null) {
            CarbonConfig.NETWORK.sendToServer(packet);
        }
    }

    @Override
    public void onConfigErrored(ConfigHandler configHandler) {
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.processEvents();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.processEvents();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onConfigsLoaded() {
        this.loadDefaultTypes();
        Object2ObjectLinkedOpenHashMap mappedConfigs = new Object2ObjectLinkedOpenHashMap();
        this.configs.forEach((arg_0, arg_1) -> EventHandler.lambda$onConfigsLoaded$0((Object2ObjectMap)mappedConfigs, arg_0, arg_1));
        if (CarbonConfig.FORGE_SUPPORT.get()) {
            ModList.get().forEachModInOrder(arg_0 -> EventHandler.lambda$onConfigsLoaded$1((Object2ObjectMap)mappedConfigs, arg_0));
        }
        mappedConfigs.forEach((M, C) -> M.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((U, S) -> this.create((Screen)S, ModConfigList.createMultiIfApplicable(M, C)))));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void loadDefaultTypes() {
        ISuggestionRenderer.Registry.register(Item.class, new SuggestionRenderers.ItemEntry());
        ISuggestionRenderer.Registry.register(Block.class, new SuggestionRenderers.ItemEntry());
        ISuggestionRenderer.Registry.register(Fluid.class, new SuggestionRenderers.FluidEntry());
        ISuggestionRenderer.Registry.register(Enchantment.class, new SuggestionRenderers.EnchantmentEntry());
        ISuggestionRenderer.Registry.register(ColorValue.ColorWrapper.class, new SuggestionRenderers.ColorEntry());
        ISuggestionRenderer.Registry.register(MobEffect.class, new SuggestionRenderers.PotionEntry());
        DataType.registerType(Item.class, RegistryElement.createForType(Item.class, "minecraft:air"));
        DataType.registerType(Block.class, RegistryElement.createForType(Block.class, "minecraft:air"));
        DataType.registerType(Fluid.class, RegistryElement.createForType(Fluid.class, "minecraft:empty"));
        DataType.registerType(Enchantment.class, RegistryElement.createForType(Enchantment.class, "minecraft:fortune"));
        DataType.registerType(MobEffect.class, RegistryElement.createForType(MobEffect.class, "minecraft:luck"));
        DataType.registerType(ColorValue.ColorWrapper.class, new DataType(false, "0xFFFFFFFF", ColorElement::new, ColorElement::new, ColorElement::new));
    }

    @OnlyIn(value=Dist.CLIENT)
    private Screen create(Screen screen, IModConfigs configs) {
        return new ConfigSelectorScreen(configs, screen);
    }

    public void onServerJoinPacket(Player player) {
        CarbonConfig.NETWORK.sendToPlayer(new StateSyncPacket(Dist.DEDICATED_SERVER), player);
        CarbonConfig.NETWORK.onPlayerJoined(player, true);
        BulkSyncPacket packet = BulkSyncPacket.create(CarbonConfig.CONFIGS.getConfigsToSync(), SyncType.SERVER_TO_CLIENT, true);
        if (packet == null) {
            return;
        }
        CarbonConfig.NETWORK.sendToPlayer(packet, player);
    }

    @SubscribeEvent
    public void onServerLeaveEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        CarbonConfig.NETWORK.onPlayerLeft(event.getEntity(), true);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerServerJoinEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        if (Minecraft.getInstance().getCurrentServer() == null) {
            this.loadMPConfigs();
        }
        CarbonConfig.NETWORK.sendToServer(new StateSyncPacket(Dist.CLIENT));
        BulkSyncPacket packet = BulkSyncPacket.create(CarbonConfig.CONFIGS.getConfigsToSync(), SyncType.CLIENT_TO_SERVER, true);
        if (packet == null) {
            return;
        }
        CarbonConfig.NETWORK.sendToServer(packet);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerServerLeaveEvent(ClientPlayerNetworkEvent.LoggingOut event) {
        CarbonConfig.NETWORK.onPlayerLeft((Player)event.getPlayer(), false);
        if (!Minecraft.getInstance().isLocalServer()) {
            for (ConfigHandler handler : CarbonConfig.CONFIGS.getAllConfigs()) {
                if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
                handler.unload();
            }
        }
    }

    private void loadMPConfigs() {
        for (ConfigHandler handler : CarbonConfig.CONFIGS.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.load();
        }
    }

    private void processEvents() {
        CarbonConfig.CONFIGS.processFileSystemEvents();
    }

    private static /* synthetic */ void lambda$onConfigsLoaded$1(Object2ObjectMap mappedConfigs, ModContainer T) {
        if (T.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).isEmpty()) {
            ForgeConfigs configs = new ForgeConfigs(T);
            if (configs.hasConfigs()) {
                ((List)mappedConfigs.supplyIfAbsent((Object)T, ObjectArrayList::new)).add(configs);
            } else if (T instanceof MinecraftModContainer) {
                ((List)mappedConfigs.supplyIfAbsent((Object)T, ObjectArrayList::new)).add(new MinecraftConfigs());
            }
        }
    }

    private static /* synthetic */ void lambda$onConfigsLoaded$0(Object2ObjectMap mappedConfigs, ModContainer M, ModConfigs C) {
        if (M.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).isPresent()) {
            return;
        }
        ((List)mappedConfigs.supplyIfAbsent((Object)M, ObjectArrayList::new)).add(C);
    }
}

