/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking;

import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import carbonconfiglib.networking.carbon.ConfigRequestPacket;
import carbonconfiglib.networking.carbon.SaveConfigPacket;
import carbonconfiglib.networking.carbon.StateSyncPacket;
import carbonconfiglib.networking.forge.RequestConfigPacket;
import carbonconfiglib.networking.forge.SaveForgeConfigPacket;
import carbonconfiglib.networking.minecraft.RequestGameRulesPacket;
import carbonconfiglib.networking.minecraft.SaveGameRulesPacket;
import carbonconfiglib.networking.snyc.BulkSyncPacket;
import carbonconfiglib.networking.snyc.SyncPacket;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.sets.ObjectOpenHashSet;

public class CarbonNetwork {
    public static final String VERSION = "1.0.0";
    Set<UUID> clientInstalledPlayers = new ObjectOpenHashSet();
    boolean serverInstalled = false;

    public void init(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar type = event.registrar("carbonconfig").optional().versioned(VERSION);
        type.play(SyncPacket.ID, this.readPacket(SyncPacket::new), this::handlePacket);
        type.play(BulkSyncPacket.ID, this.readPacket(BulkSyncPacket::new), this::handlePacket);
        type.play(ConfigRequestPacket.ID, this.readPacket(ConfigRequestPacket::new), this::handlePacket);
        type.play(ConfigAnswerPacket.ID, this.readPacket(ConfigAnswerPacket::new), this::handlePacket);
        type.play(SaveConfigPacket.ID, this.readPacket(SaveConfigPacket::new), this::handlePacket);
        type.play(RequestConfigPacket.ID, this.readPacket(RequestConfigPacket::new), this::handlePacket);
        type.play(SaveForgeConfigPacket.ID, this.readPacket(SaveForgeConfigPacket::new), this::handlePacket);
        type.play(RequestGameRulesPacket.ID, this.readPacket(RequestGameRulesPacket::new), this::handlePacket);
        type.play(SaveGameRulesPacket.ID, this.readPacket(SaveGameRulesPacket::new), this::handlePacket);
        type.play(StateSyncPacket.ID, this.readPacket(StateSyncPacket::new), this::handlePacket);
    }

    protected <T extends ICarbonPacket> FriendlyByteBuf.Reader<T> readPacket(Function<FriendlyByteBuf, T> provider) {
        return B -> {
            try {
                return (ICarbonPacket)provider.apply((FriendlyByteBuf)B);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        };
    }

    protected void handlePacket(ICarbonPacket packet, IPayloadContext provider) {
        try {
            provider.workHandler().execute(() -> packet.process(this.getPlayer(provider)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isInWorld() {
        return this.getClientPlayer() != null;
    }

    protected Player getPlayer(IPayloadContext cont) {
        Optional entity = cont.player();
        return entity.isPresent() ? (Player)entity.get() : this.getClientPlayer();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Player getClientPlayer() {
        Minecraft mc = Minecraft.getInstance();
        return mc == null ? null : mc.player;
    }

    public void sendToServer(ICarbonPacket packet) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{packet});
    }

    public void sendToAllPlayers(ICarbonPacket packet) {
        for (ServerPlayer player : this.getAllPlayers()) {
            PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{packet});
        }
    }

    public void onPlayerJoined(Player player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.add(player.getUUID());
        } else {
            this.serverInstalled = true;
        }
    }

    public void onPlayerLeft(Player player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.remove(player.getUUID());
        } else {
            this.serverInstalled = false;
        }
    }

    private List<ServerPlayer> getAllPlayers() {
        ObjectArrayList players = new ObjectArrayList();
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
            if (!this.isInstalledOnClient(player)) continue;
            players.add(player);
        }
        return players;
    }

    public boolean isInstalled(Player player) {
        return player instanceof ServerPlayer ? this.isInstalledOnClient((ServerPlayer)player) : this.isInstalledOnServer();
    }

    public boolean isInstalledOnClient(ServerPlayer player) {
        return this.clientInstalledPlayers.contains(player.getUUID());
    }

    public boolean isInstalledOnServer() {
        return this.serverInstalled;
    }

    public void sendToPlayer(ICarbonPacket packet, Player player) {
        if (!(player instanceof ServerPlayer)) {
            throw new RuntimeException("Sending a Packet to a Player from client is not allowed");
        }
        PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)).send(new CustomPacketPayload[]{packet});
    }
}

