/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.carbon;

import carbonconfiglib.gui.api.IRequestScreen;
import carbonconfiglib.networking.ICarbonPacket;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ConfigAnswerPacket
implements ICarbonPacket {
    public static final ResourceLocation ID = new ResourceLocation("carbonconfig", "answer");
    UUID id;
    byte[] data;

    public ConfigAnswerPacket(UUID id, byte[] data) {
        this.id = id;
        this.data = data;
    }

    public ConfigAnswerPacket(FriendlyByteBuf buffer) {
        this.id = buffer.readUUID();
        this.data = buffer.readByteArray();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.id);
        buffer.writeByteArray(this.data);
    }

    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void process(Player player) {
        this.processClient();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void processClient() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof IRequestScreen) {
            ((IRequestScreen)screen).receiveConfigData(this.id, new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])this.data)));
        }
    }
}

