/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.carbon;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import carbonconfiglib.utils.MultilinePolicy;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ConfigRequestPacket
implements ICarbonPacket {
    public static final ResourceLocation ID = new ResourceLocation("carbonconfig", "request_carbon");
    UUID id;
    String identifier;

    public ConfigRequestPacket(FriendlyByteBuf buffer) {
        this.id = buffer.readUUID();
        this.identifier = buffer.readUtf(Short.MAX_VALUE);
    }

    public ConfigRequestPacket(UUID id, String identifier) {
        this.id = id;
        this.identifier = identifier;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.id);
        buffer.writeUtf(this.identifier, Short.MAX_VALUE);
    }

    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void process(Player player) {
        if (!CarbonConfig.hasPermission(player, 4)) {
            return;
        }
        ConfigHandler handler = CarbonConfig.CONFIGS.getConfig(this.identifier);
        if (handler == null) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeUtf(handler.getConfig().serialize(MultilinePolicy.DISABLED), 262144);
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        CarbonConfig.NETWORK.sendToPlayer(new ConfigAnswerPacket(this.id, data), player);
    }
}

