/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.carbon;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.impl.internal.EventHandler;
import carbonconfiglib.networking.ICarbonPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;

public class StateSyncPacket
implements ICarbonPacket {
    public static final ResourceLocation ID = new ResourceLocation("carbonconfig", "state");
    Dist source;

    public StateSyncPacket(Dist source) {
        this.source = source;
    }

    public StateSyncPacket(FriendlyByteBuf buffer) {
        this.source = buffer.readBoolean() ? Dist.CLIENT : Dist.DEDICATED_SERVER;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.source.isClient());
    }

    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void process(Player player) {
        if (this.source.isDedicatedServer()) {
            CarbonConfig.NETWORK.onPlayerJoined(player, false);
        } else {
            EventHandler.INSTANCE.onServerJoinPacket(player);
        }
    }
}

