/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.minecraft;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class RequestGameRulesPacket
implements ICarbonPacket {
    public static final ResourceLocation ID = new ResourceLocation("carbonconfig", "request_mc");
    UUID requestId;

    public RequestGameRulesPacket(UUID requestId) {
        this.requestId = requestId;
    }

    public RequestGameRulesPacket(FriendlyByteBuf buffer) {
        this.requestId = buffer.readUUID();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.requestId);
    }

    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void process(Player player) {
        if (!CarbonConfig.hasPermission(player, 4)) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeNbt((Tag)server.getGameRules().createTag());
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        CarbonConfig.NETWORK.sendToPlayer(new ConfigAnswerPacket(this.requestId, data), player);
    }
}

