/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.forge.networking;

import com.natamus.collective_common_forge.data.Constants;
import com.natamus.collective_common_forge.implementations.networking.PacketRegistrationHandler;
import com.natamus.collective_common_forge.implementations.networking.data.PacketContainer;
import com.natamus.collective_common_forge.implementations.networking.data.PacketContext;
import com.natamus.collective_common_forge.implementations.networking.data.Side;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

public class ForgeNetworkHandler
extends PacketRegistrationHandler {
    private final Map<Class<?>, SimpleChannel> CHANNELS = new HashMap();

    public ForgeNetworkHandler(Side side) {
        super(side);
    }

    @Override
    protected <T> void registerPacket(PacketContainer<T> container) {
        if (this.CHANNELS.get(container.messageType()) == null) {
            SimpleChannel channel = ChannelBuilder.named((ResourceLocation)container.packetIdentifier()).clientAcceptedVersions((a, b) -> true).serverAcceptedVersions((a, b) -> true).networkProtocolVersion(1).simpleChannel();
            channel.messageBuilder(container.messageType()).decoder(container.decoder()).encoder(container.encoder()).consumerNetworkThread(this.buildHandler(container.handler())).add();
            Constants.LOG.debug("Registering packet {} : {} on the: {}", new Object[]{container.packetIdentifier(), container.messageType(), this.side});
            this.CHANNELS.put(container.messageType(), channel);
        }
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.sendToServer(packet, false);
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        SimpleChannel channel = this.CHANNELS.get(packet.getClass());
        Connection connection = Minecraft.m_91087_().m_91403_().m_104910_();
        try {
            if (ignoreCheck || channel.isRemotePresent(connection)) {
                channel.send(packet, PacketDistributor.SERVER.noArg());
            }
        }
        catch (Throwable t) {
            Constants.LOG.error("{} packet not registered on the client, this is needed for fabric.", packet.getClass(), (Object)t);
        }
    }

    @Override
    public <T> void sendToClient(T packet, ServerPlayer player) {
        SimpleChannel channel = this.CHANNELS.get(packet.getClass());
        Connection connection = player.f_8906_.getConnection();
        try {
            if (channel.isRemotePresent(connection)) {
                channel.send(packet, PacketDistributor.PLAYER.with((Object)player));
            }
        }
        catch (Throwable t) {
            Constants.LOG.error("{} packet not registered on the server, this is needed for fabric.", packet.getClass(), (Object)t);
        }
    }

    private <T> BiConsumer<T, CustomPayloadEvent.Context> buildHandler(Consumer<PacketContext<T>> handler) {
        return (message, ctx) -> {
            ctx.enqueueWork(() -> {
                Side side = ctx.getDirection().getReceptionSide().isServer() ? Side.SERVER : Side.CLIENT;
                ServerPlayer player = ctx.getSender();
                handler.accept(new PacketContext<Object>((Player)player, message, side));
            });
            ctx.setPacketHandled(true);
        };
    }
}

