/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_fabric.functions;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.natamus.collective_common_fabric.features.PlayerHeadCacheFeature;
import com.natamus.collective_common_fabric.functions.UUIDFunctions;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3312;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;

public class HeadFunctions {
    public static class_1799 getNewPlayerHead(class_3218 serverLevel, String playerName, Integer amount) {
        GameProfile gameProfile = HeadFunctions.getGameProfileFromPlayerName(serverLevel, playerName);
        if (gameProfile == null) {
            return null;
        }
        return HeadFunctions.getNewPlayerHead(gameProfile, amount);
    }

    public static class_1799 getNewPlayerHead(GameProfile gameProfile, Integer amount) {
        if (gameProfile == null) {
            return null;
        }
        String playerName = gameProfile.getName();
        PropertyMap propertyMap = gameProfile.getProperties();
        String texturePropertyValue = "";
        for (Property textureProperty : propertyMap.get((Object)"textures")) {
            if (!textureProperty.name().equals("textures")) continue;
            texturePropertyValue = textureProperty.value();
            break;
        }
        if (!texturePropertyValue.contains("cHJvZmlsZUlk")) {
            return null;
        }
        String textures = "ewogICJ0aW1lc3RhbXAiIDogMCwKICAicHJvZmlsZUlk" + texturePropertyValue.split("cHJvZmlsZUlk")[1];
        int[] headIntArray = class_4844.method_26275((UUID)gameProfile.getId());
        class_1799 playerHeadStack = HeadFunctions.getNewTexturedHead(playerName, textures, headIntArray, amount);
        playerHeadStack.method_7977((class_2561)class_2561.method_43470((String)(playerName + "'s Head")));
        return playerHeadStack;
    }

    public static class_1799 getNewTexturedHead(String entityName, String texture, String uuidString, Integer amount) {
        UUID uuid = UUIDFunctions.getUUIDFromStringLenient(uuidString);
        int[] intArray = class_4844.method_26275((UUID)uuid);
        return HeadFunctions.getNewTexturedHead(entityName, texture, intArray, amount);
    }

    public static class_1799 getNewTexturedHead(String entityName, String texture, int[] idIntArray, Integer amount) {
        if (entityName.length() > 16) {
            entityName = entityName.substring(0, 16);
        }
        class_1799 texturedHeadStack = new class_1799((class_1935)class_1802.field_8575, amount.intValue());
        class_2487 skullOwnerCompoundTag = HeadFunctions.getSkullOwnerCompoundTag(entityName.replace(" ", "_"), texture, idIntArray);
        texturedHeadStack.method_7959("SkullOwner", (class_2520)skullOwnerCompoundTag);
        return texturedHeadStack;
    }

    public static GameProfile getGameProfileFromPlayerName(class_3218 serverLevel, String playerName) {
        GameProfile gameProfile;
        UUID headUUID;
        MinecraftSessionService minecraftSessionService = serverLevel.method_8503().method_3844();
        MinecraftServer minecraftServer = serverLevel.method_8503();
        class_3312 gameProfileCache = minecraftServer.method_3793();
        if (PlayerHeadCacheFeature.cachedPlayerNamesMap.containsKey(playerName.toLowerCase())) {
            headUUID = PlayerHeadCacheFeature.cachedPlayerNamesMap.get(playerName.toLowerCase());
            playerName = PlayerHeadCacheFeature.cachedPlayerUUIDsMap.get(headUUID);
        } else {
            Optional playerNameGameProfileOptional = gameProfileCache.method_14515(playerName);
            if (playerNameGameProfileOptional.isEmpty()) {
                return null;
            }
            GameProfile playerNameGameProfile = (GameProfile)playerNameGameProfileOptional.get();
            if (playerNameGameProfile == null) {
                return null;
            }
            headUUID = playerNameGameProfile.getId();
            PlayerHeadCacheFeature.cachedPlayerNamesMap.put(playerNameGameProfile.getName().toLowerCase(), headUUID);
            PlayerHeadCacheFeature.cachedPlayerUUIDsMap.put(headUUID, playerNameGameProfile.getName());
        }
        if (PlayerHeadCacheFeature.cachedGameProfileMap.containsKey(headUUID)) {
            gameProfile = PlayerHeadCacheFeature.cachedGameProfileMap.get(headUUID);
        } else {
            ProfileResult profileResult = minecraftSessionService.fetchProfile(headUUID, false);
            if (profileResult == null) {
                return null;
            }
            gameProfile = profileResult.profile();
            if (gameProfile == null) {
                return null;
            }
            PlayerHeadCacheFeature.cachedGameProfileMap.put(headUUID, gameProfile);
        }
        return gameProfile;
    }

    public static class_2487 getSkullOwnerCompoundTag(class_3218 serverLevel, String playerName) {
        GameProfile gameProfile = HeadFunctions.getGameProfileFromPlayerName(serverLevel, playerName);
        PropertyMap propertyMap = gameProfile.getProperties();
        String textures = "";
        for (Property textureProperty : propertyMap.get((Object)"textures")) {
            if (!textureProperty.name().equals("textures")) continue;
            textures = textureProperty.value();
        }
        if (textures.equals("")) {
            return null;
        }
        int[] headIntArray = class_4844.method_26275((UUID)gameProfile.getId());
        return HeadFunctions.getSkullOwnerCompoundTag(playerName, textures, headIntArray);
    }

    public static class_2487 getSkullOwnerCompoundTag(String entityName, String textures, int[] idIntArray) {
        class_2487 skullOwnerCompoundTag = new class_2487();
        skullOwnerCompoundTag.method_10582("Name", entityName);
        skullOwnerCompoundTag.method_10539("Id", idIntArray);
        class_2487 propertiesCompoundTag = new class_2487();
        class_2499 texturesListTag = new class_2499();
        class_2487 texturesCompoundTag = new class_2487();
        texturesCompoundTag.method_10582("Value", textures);
        texturesListTag.add((Object)texturesCompoundTag);
        propertiesCompoundTag.method_10566("textures", (class_2520)texturesListTag);
        skullOwnerCompoundTag.method_10566("Properties", (class_2520)propertiesCompoundTag);
        return skullOwnerCompoundTag;
    }

    public static boolean hasStandardHead(String mobname) {
        return mobname.equals("creeper") || mobname.equals("zombie") || mobname.equals("skeleton");
    }
}

