/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.block;

import dev.su5ed.mffs.api.ForceFieldBlock;
import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.Module;
import dev.su5ed.mffs.api.security.BiometricIdentifier;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.blockentity.ForceFieldBlockEntity;
import dev.su5ed.mffs.compat.CreateTrainCompat;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.util.ModUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ForceFieldBlockImpl
extends Block
implements ForceFieldBlock,
EntityBlock {
    private static final VoxelShape COLLIDABLE_BLOCK = Shapes.create((double)0.01, (double)0.01, (double)0.01, (double)0.99, (double)0.99, (double)0.99);

    public ForceFieldBlockImpl() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).destroyTime(-1.0f).strength(-1.0f, 3600000.0f).noLootTable());
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamouflageBlock(level, pos).filter(this::preventStackOverflow).map(block -> block.propagatesSkylightDown(level, pos)).orElse(true);
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamouflageBlock(level, pos).filter(this::preventStackOverflow).map(block -> Float.valueOf(block.getShadeBrightness(level, pos))).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction side) {
        return this.getCamouflageBlock(level, pos).filter(this::preventStackOverflow).flatMap(block -> this.getCamouflageBlock(level, pos.relative(side)).map(neighbor -> block.skipRendering(neighbor, side))).orElseGet(() -> neighborState.is((Block)this));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getCamouflageBlock(level, pos).filter(this::preventStackOverflow).map(block -> block.getShape(level, pos)).orElseGet(() -> super.getShape(state, level, pos, context));
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getCamouflageBlock(level, pos).filter(this::preventStackOverflow).map(block -> block.getVisualShape(level, pos, context)).orElseGet(Shapes::empty);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamouflageBlock(level, pos).filter(this::preventStackOverflow).map(block -> block.getOcclusionShape(level, pos)).orElseGet(() -> super.getOcclusionShape(state, level, pos));
    }

    @Override
    public Optional<Projector> getProjector(BlockGetter level, BlockPos pos) {
        Optional<Projector> optional;
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof ForceFieldBlockEntity) {
            ForceFieldBlockEntity forceField = (ForceFieldBlockEntity)be;
            optional = forceField.getProjector();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    private Optional<BlockState> getCamouflageBlock(BlockGetter level, BlockPos pos) {
        return Optional.ofNullable(level.getBlockEntity(pos)).map(be -> {
            BlockState blockState;
            if (be instanceof ForceFieldBlockEntity) {
                ForceFieldBlockEntity forceField = (ForceFieldBlockEntity)((Object)be);
                blockState = forceField.getCamouflage();
            } else {
                blockState = null;
            }
            return blockState;
        });
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ItemStack.EMPTY;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return Optional.ofNullable(level.getBlockEntity(pos)).map(be -> {
            Integer n;
            if (be instanceof ForceFieldBlockEntity) {
                ForceFieldBlockEntity f = (ForceFieldBlockEntity)((Object)be);
                n = f.getClientBlockLight();
            } else {
                n = null;
            }
            return n;
        }).orElseGet(() -> super.getLightEmission(state, level, pos));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getProjector(level, pos).map(projector -> {
            EntityCollisionContext entityContext;
            Entity patt5536$temp;
            if (context instanceof EntityCollisionContext && (patt5536$temp = (entityContext = (EntityCollisionContext)context).getEntity()) instanceof Player) {
                Player player = (Player)patt5536$temp;
                BiometricIdentifier bioIndentifier = projector.getBiometricIdentifier();
                if (player.isShiftKeyDown() && !context.isAbove(COLLIDABLE_BLOCK, pos, true) && (player.isCreative() || bioIndentifier != null && bioIndentifier.isAccessGranted(player, FieldPermission.WARP))) {
                    return Shapes.empty();
                }
            }
            return null;
        }).orElse(COLLIDABLE_BLOCK);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        this.getProjector((BlockGetter)level, pos).ifPresent(projector -> {
            block6: {
                block7: {
                    Player player;
                    for (Module module : projector.getModuleInstances()) {
                        if (!module.onCollideWithForceField(level, pos, entity)) continue;
                        return;
                    }
                    if (entity.level().isClientSide) break block6;
                    Vec3 vec3 = new Vec3((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                    if (!(entity.distanceToSqr(vec3) < Mth.square((double)0.7))) break block6;
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        if (!(entity instanceof Player) || !(player = (Player)entity).isCreative()) {
                            living.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 80, 3));
                            living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 1));
                        }
                    }
                    BiometricIdentifier identifier = projector.getBiometricIdentifier();
                    if (!(entity instanceof Player)) break block7;
                    player = (Player)entity;
                    if (this.isSneaking(entity) && (player.isCreative() || identifier != null && identifier.isAccessGranted(player, FieldPermission.WARP))) break block6;
                }
                ModUtil.shockEntity(entity, Integer.MAX_VALUE);
            }
        });
    }

    private boolean isSneaking(Entity entity) {
        return entity.isShiftKeyDown() || CreateTrainCompat.isTrainPassenger(entity);
    }

    private boolean preventStackOverflow(BlockState state) {
        return !state.is((Block)this);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModObjects.FORCE_FIELD_BLOCK_ENTITY.get()).create(pos, state);
    }
}

