/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class BaseBlockEntity
extends BlockEntity
implements MenuProvider {
    private long tickCounter;

    protected BaseBlockEntity(BlockEntityType<? extends BaseBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public long getTicks() {
        return this.tickCounter;
    }

    public void tickClient() {
        ++this.tickCounter;
    }

    public void tickServer() {
        ++this.tickCounter;
    }

    public void beforeBlockRemove() {
    }

    public void provideAdditionalDrops(List<? super ItemStack> drops) {
    }

    public InteractionResult use(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.level.isClientSide) {
            player.openMenu((MenuProvider)this, this.worldPosition);
        }
        return InteractionResult.SUCCESS;
    }

    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    public CompoundTag getUpdateTag() {
        CompoundTag tag = new CompoundTag();
        this.saveCommonTag(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.loadCommonTag(tag);
    }

    public final void load(CompoundTag tag) {
        super.load(tag);
        this.loadCommonTag(tag);
        this.loadTag(tag);
    }

    protected final void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        this.saveCommonTag(tag);
        this.saveTag(tag);
    }

    protected void loadCommonTag(CompoundTag tag) {
    }

    protected void saveCommonTag(CompoundTag tag) {
    }

    protected void loadTag(CompoundTag tag) {
    }

    protected void saveTag(CompoundTag tag) {
    }

    public <T extends CustomPacketPayload> void sendToChunk(T msg) {
        PacketDistributor.TRACKING_CHUNK.with((Object)this.level.getChunkAt(this.worldPosition)).send(new CustomPacketPayload[]{msg});
    }
}

