/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import com.google.common.base.Suppliers;
import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import dev.su5ed.mffs.blockentity.ModularBlockEntity;
import dev.su5ed.mffs.util.CustomEnergyStorage;
import dev.su5ed.mffs.util.SidedEnergyWrapper;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public abstract class ElectricTileEntity
extends ModularBlockEntity {
    protected final CustomEnergyStorage energy;
    private final Map<Direction, Supplier<IEnergyStorage>> sidedEnergyCap;

    protected ElectricTileEntity(BlockEntityType<? extends BaseBlockEntity> type, BlockPos pos, BlockState state, int capacity) {
        super(type, pos, state);
        this.energy = new CustomEnergyStorage(capacity, Integer.MAX_VALUE, this::isActive, () -> ((ElectricTileEntity)this).setChanged());
        Set<Direction> inputSides = this.getEnergyInputSides();
        Set<Direction> outputSides = this.getEnergyOutputSides();
        this.sidedEnergyCap = ((StreamEx)StreamEx.of(inputSides).append(outputSides).distinct()).mapToEntry(side -> Suppliers.memoize(() -> new SidedEnergyWrapper((IEnergyStorage)this.energy, side == null || inputSides.contains(side), side == null || outputSides.contains(side)))).toMap();
    }

    @Nullable
    public IEnergyStorage getEnergy(Direction side) {
        Supplier<IEnergyStorage> supplier = this.sidedEnergyCap.get(side);
        return supplier != null ? supplier.get() : null;
    }

    public void charge(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy != null) {
            this.energy.extractEnergy(energy.receiveEnergy(this.energy.getEnergyStored(), false), false);
        }
    }

    public void discharge(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy != null) {
            this.energy.receiveEnergy(energy.extractEnergy(this.energy.getRequestedEnergy(), false), false);
        }
    }

    protected long receiveEnergy() {
        long totalUsed = 0L;
        for (Direction direction : this.getEnergyOutputSides()) {
            if (this.energy.getEnergyStored() <= 0) continue;
            int received = Optional.ofNullable((IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.worldPosition.relative(direction), (Object)direction.getOpposite())).map(energy -> energy.receiveEnergy(this.energy.extractEnergy(this.energy.getEnergyStored(), true), false)).orElse(0);
            totalUsed += (long)this.energy.extractEnergy(received, false);
        }
        return totalUsed;
    }

    public Set<Direction> getEnergyInputSides() {
        return Collections.emptySet();
    }

    public Set<Direction> getEnergyOutputSides() {
        return Collections.emptySet();
    }

    public IEnergyStorage getGlobalEnergyStorage() {
        return this.energy;
    }

    @Override
    protected void saveTag(CompoundTag tag) {
        super.saveTag(tag);
        tag.put("energy", this.energy.serializeNBT());
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.energy.deserializeNBT(tag.get("energy"));
    }
}

