/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import dev.su5ed.mffs.MFFSConfig;
import dev.su5ed.mffs.api.module.InterdictionMatrixModule;
import dev.su5ed.mffs.api.module.Module;
import dev.su5ed.mffs.api.security.BiometricIdentifier;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.api.security.InterdictionMatrix;
import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import dev.su5ed.mffs.blockentity.ModularBlockEntity;
import dev.su5ed.mffs.menu.InterdictionMatrixMenu;
import dev.su5ed.mffs.setup.ModItems;
import dev.su5ed.mffs.setup.ModModules;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.inventory.InventorySlot;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class InterdictionMatrixBlockEntity
extends ModularBlockEntity
implements InterdictionMatrix {
    public final InventorySlot secondaryCard;
    public final List<InventorySlot> upgradeSlots;
    public final List<InventorySlot> bannedItemSlots;
    private InterdictionMatrix.ConfiscationMode confiscationMode = InterdictionMatrix.ConfiscationMode.BLACKLIST;

    public InterdictionMatrixBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends BaseBlockEntity>)((BlockEntityType)ModObjects.INTERDICTION_MATRIX_BLOCK_ENTITY.get()), pos, state);
        this.secondaryCard = this.addSlot("secondaryCard", InventorySlot.Mode.BOTH, stack -> ModUtil.isCard(stack) || stack.is((Item)ModItems.INFINITE_POWER_CARD.get()), this::onFrequencySlotChanged);
        this.upgradeSlots = this.createUpgradeSlots(8, Module.Category.INTERDICTION, (ItemStack stack) -> {});
        this.bannedItemSlots = IntStreamEx.range((int)9).mapToObj(i -> this.addSlot("banned_item_" + i, InventorySlot.Mode.NONE)).toList();
    }

    @Override
    public int getWarningRange() {
        return this.getModuleCount(ModModules.WARN) + this.getActionRange() + 3;
    }

    @Override
    public int getActionRange() {
        return this.getModuleCount(ModModules.SCALE);
    }

    @Override
    public BlockEntity be() {
        return this;
    }

    @Override
    public Collection<ItemStack> getFilteredItems() {
        return ((StreamEx)StreamEx.of(this.bannedItemSlots).remove(InventorySlot::isEmpty)).map(InventorySlot::getItem).toList();
    }

    @Override
    public InterdictionMatrix.ConfiscationMode getConfiscationMode() {
        return this.confiscationMode;
    }

    @Override
    public Component getTitle() {
        return this.getDisplayName();
    }

    public void setConfiscationMode(InterdictionMatrix.ConfiscationMode confiscationMode) {
        this.confiscationMode = confiscationMode;
    }

    @Override
    protected void addModuleSlots(List<? super InventorySlot> list) {
        super.addModuleSlots(list);
        list.addAll(this.upgradeSlots);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.getTicks() % 10L == 0L && (this.isActive() || this.frequencySlot.getItem().is((Item)ModItems.INFINITE_POWER_CARD.get())) && this.fortronStorage.extractFortron(this.getFortronCost() * 10, true) > 0) {
            this.fortronStorage.extractFortron(this.getFortronCost() * 10, false);
            this.scan();
        }
    }

    @Override
    protected float getAmplifier() {
        return Math.max(Math.min(this.getActionRange() / 20, 10), 1);
    }

    public void scan() {
        BiometricIdentifier identifier = this.getBiometricIdentifier();
        AABB emptyBounds = AABB.encapsulatingFullBlocks((BlockPos)this.worldPosition, (BlockPos)this.worldPosition.offset(1, 1, 1));
        List warningList = this.level.getEntitiesOfClass(LivingEntity.class, emptyBounds.inflate((double)this.getWarningRange(), (double)this.getWarningRange(), (double)this.getWarningRange()));
        List actionList = this.level.getEntitiesOfClass(LivingEntity.class, emptyBounds.inflate((double)this.getActionRange(), (double)this.getActionRange(), (double)this.getActionRange()));
        for (LivingEntity entity : warningList) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (actionList.contains(entity) || this.canPlayerBypass(identifier, player) || this.level.random.nextInt(3) != 0) continue;
            player.displayClientMessage((Component)ModUtil.translate("info", "interdiction_matrix.warning", this.getTitle()).withStyle(ChatFormatting.RED), false);
        }
        if (this.level.random.nextInt(3) == 0) {
            for (LivingEntity entity : actionList) {
                this.applyAction(entity);
            }
        }
    }

    public void applyAction(LivingEntity target) {
        InterdictionMatrixModule interdictionModule;
        Module module;
        if (target instanceof Player) {
            Player player = (Player)target;
            BiometricIdentifier identifier = this.getBiometricIdentifier();
            if (this.canPlayerBypass(identifier, player) || ((Boolean)MFFSConfig.COMMON.interactCreative.get()).booleanValue() && player.isCreative()) {
                return;
            }
        }
        Iterator<Module> iterator = this.getModuleInstances().iterator();
        while (!(!iterator.hasNext() || (module = iterator.next()) instanceof InterdictionMatrixModule && (interdictionModule = (InterdictionMatrixModule)module).onDefend(this, target) || target.isDeadOrDying())) {
        }
    }

    public boolean canPlayerBypass(BiometricIdentifier identifier, Player player) {
        return identifier != null && identifier.isAccessGranted(player, FieldPermission.BYPASS_CONFISCATION);
    }

    @Override
    protected void loadCommonTag(CompoundTag tag) {
        super.loadCommonTag(tag);
        this.confiscationMode = InterdictionMatrix.ConfiscationMode.valueOf(tag.getString("confiscationMode"));
    }

    @Override
    protected void saveCommonTag(CompoundTag tag) {
        super.saveCommonTag(tag);
        tag.putString("confiscationMode", this.confiscationMode.name());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new InterdictionMatrixMenu(containerId, this.worldPosition, player, playerInventory);
    }
}

