/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.datagen;

import dev.su5ed.mffs.MFFSMod;
import dev.su5ed.mffs.block.BaseEntityBlock;
import dev.su5ed.mffs.setup.ModBlocks;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredBlock;
import one.util.streamex.StreamEx;

final class LootTableGen {
    private LootTableGen() {
    }

    public static class ModItemLoot
    implements LootTableSubProvider {
        public void generate(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            Item book = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation("patchouli", "guide_book"));
            CompoundTag tag = new CompoundTag();
            tag.putString("patchouli:book", "mffs:handbook");
            consumer.accept(MFFSMod.location("grant_book_on_first_join"), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)book)).apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)tag))));
        }
    }

    public static class ModBlockLoot
    extends BlockLootSubProvider {
        private final List<Block> blocks = StreamEx.of((Object[])new DeferredBlock[]{ModBlocks.COERCION_DERIVER, ModBlocks.FORTRON_CAPACITOR, ModBlocks.PROJECTOR, ModBlocks.BIOMETRIC_IDENTIFIER, ModBlocks.INTERDICTION_MATRIX}).map(Supplier::get).toList();

        protected ModBlockLoot() {
            super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags());
        }

        protected void generate() {
            for (Block block : this.blocks) {
                this.add(block, LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block)))).withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)DynamicLoot.dynamicEntry((ResourceLocation)BaseEntityBlock.CONTENT_KEY)))));
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.blocks;
        }
    }
}

