/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.item;

import dev.su5ed.mffs.util.ModUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class BatteryItem
extends Item {
    private final int capacity;
    private final int maxTransfer;

    public BatteryItem() {
        this(100000, 1000);
    }

    public BatteryItem(int capacity, int maxTransfer) {
        super(new Item.Properties().stacksTo(1));
        this.capacity = capacity;
        this.maxTransfer = maxTransfer;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getMaxTransfer() {
        return this.maxTransfer;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, level, tooltipComponents, isAdvanced);
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy != null) {
            tooltipComponents.add((Component)ModUtil.translate("info", "stored_energy", Component.literal((String)String.valueOf(energy.getEnergyStored())).withStyle(ChatFormatting.GRAY), Component.literal((String)String.valueOf(energy.getMaxEnergyStored())).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return BatteryItem.getChargeLevel(stack) < 1.0f;
    }

    public int getBarWidth(ItemStack stack) {
        float charge = BatteryItem.getChargeLevel(stack);
        return (int)Math.round((double)charge * 13.0);
    }

    public int getBarColor(ItemStack stack) {
        float charge = BatteryItem.getChargeLevel(stack);
        return Mth.hsvToRgb((float)(charge / 3.0f), (float)1.0f, (float)1.0f);
    }

    private static float getChargeLevel(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        return energy != null ? (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored() : 0.0f;
    }
}

