/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.item;

import dev.su5ed.mffs.MFFSConfig;
import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.ProjectorMode;
import dev.su5ed.mffs.item.BaseItem;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.loot.FieldShapeTrigger;
import dev.su5ed.mffs.util.projector.CustomStructureSavedData;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.Nullable;

public class CustomProjectorModeItem
extends BaseItem {
    public static final String TAG_PATTERN_ID = "pattern_id";
    private static final String TAG_MODE = "mode";
    public static final String TAG_POINT_PRIMARY = "primary_point";
    public static final String TAG_POINT_SECONDARY = "secondary_point";
    private CustomStructureSavedData structureManager;

    public CustomProjectorModeItem() {
        super(new BaseItem.ExtendedItemProperties(new Item.Properties().stacksTo(1)));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack stack = player.getItemInHand(usedHand);
                CompoundTag tag = stack.getOrCreateTag();
                if (player.isShiftKeyDown()) {
                    CustomStructureSavedData data = this.getOrCreateData(serverLevel);
                    if (tag.contains(TAG_POINT_PRIMARY) && tag.contains(TAG_POINT_SECONDARY)) {
                        int distance;
                        BlockPos secondary;
                        BlockPos primary = CustomProjectorModeItem.getPos(tag, TAG_POINT_PRIMARY);
                        if (primary.closerThan((Vec3i)(secondary = CustomProjectorModeItem.getPos(tag, TAG_POINT_SECONDARY)), (double)(distance = ((Integer)MFFSConfig.COMMON.maxCustomModeScale.get()).intValue()))) {
                            tag.remove(TAG_POINT_PRIMARY);
                            tag.remove(TAG_POINT_SECONDARY);
                            String id = this.getOrCreateId(tag);
                            data.join(id, level, serverPlayer, primary, secondary, this.getMode(tag) == Mode.ADDITIVE);
                            player.displayClientMessage((Component)ModUtil.translate("item", "custom_mode.data_saved", new Object[0]), true);
                            ((FieldShapeTrigger)((Object)ModObjects.FIELD_SHAPE_TRIGGER.get())).trigger(serverPlayer);
                        } else {
                            player.displayClientMessage((Component)ModUtil.translate("item", "custom_mode.too_far", distance), true);
                        }
                        return InteractionResultHolder.success((Object)stack);
                    }
                    if (tag.contains(TAG_PATTERN_ID)) {
                        String id = tag.getString(TAG_PATTERN_ID);
                        data.clear(level, serverPlayer, id);
                        tag.remove(TAG_PATTERN_ID);
                        player.displayClientMessage((Component)ModUtil.translate("item", "custom_mode.clear", new Object[0]), true);
                        return InteractionResultHolder.success((Object)stack);
                    }
                } else if (tag.contains(TAG_POINT_PRIMARY) && !tag.contains(TAG_POINT_SECONDARY)) {
                    HitResult result = player.pick(player.getBlockReach(), 0.0f, true);
                    if (result instanceof BlockHitResult) {
                        BlockHitResult blockHitResult = (BlockHitResult)result;
                        this.selectBlock(player, tag, blockHitResult.getBlockPos(), TAG_POINT_SECONDARY, ChatFormatting.GOLD);
                        return InteractionResultHolder.success((Object)stack);
                    }
                } else {
                    Mode mode = this.setMode(tag, this.getMode(tag).next());
                    player.displayClientMessage((Component)ModUtil.translate("item", "custom_mode.changed_mode", mode.getName().withStyle(ChatFormatting.GREEN)), true);
                    return InteractionResultHolder.consume((Object)stack);
                }
            }
        }
        return super.use(level, player, usedHand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        if (!level.isClientSide) {
            CompoundTag tag = stack.getOrCreateTag();
            BlockPos pos = context.getClickedPos();
            Player player = context.getPlayer();
            if (!tag.contains(TAG_POINT_PRIMARY) || tag.contains(TAG_POINT_SECONDARY)) {
                tag.remove(TAG_POINT_SECONDARY);
                this.selectBlock(player, tag, pos, TAG_POINT_PRIMARY, ChatFormatting.GREEN);
            } else {
                this.selectBlock(player, tag, pos, TAG_POINT_SECONDARY, ChatFormatting.GOLD);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void selectBlock(Player player, CompoundTag tag, BlockPos pos, String key, ChatFormatting color) {
        tag.put(key, (Tag)NbtUtils.writeBlockPos((BlockPos)pos));
        MutableComponent component = ModUtil.translate("item", "custom_mode.set_" + key, new Object[0]).withStyle(color);
        player.displayClientMessage((Component)component, true);
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag tag = stack.getOrCreateTag();
        Mode mode = this.getMode(tag);
        tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.mode", mode.getName().withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY));
        String id = tag.getString(TAG_PATTERN_ID);
        if (!id.isEmpty()) {
            tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.pattern_id", Component.literal((String)id).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (tag.contains(TAG_POINT_PRIMARY)) {
            BlockPos primary = CustomProjectorModeItem.getPos(tag, TAG_POINT_PRIMARY);
            tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.primary_point", Component.literal((String)primary.toShortString()).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY));
            if (tag.contains(TAG_POINT_SECONDARY)) {
                BlockPos secondary = CustomProjectorModeItem.getPos(tag, TAG_POINT_SECONDARY);
                tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.secondary_point", Component.literal((String)secondary.toShortString()).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY));
                tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.set_secondary_point", new Object[0]).withStyle(ChatFormatting.GOLD));
            } else {
                tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.set_primary_point", new Object[0]).withStyle(ChatFormatting.LIGHT_PURPLE));
            }
        }
        super.appendHoverText(stack, level, tooltipComponents, isAdvanced);
    }

    public Mode getMode(CompoundTag tag) {
        return tag.contains(TAG_MODE) ? Mode.valueOf(tag.getString(TAG_MODE)) : Mode.ADDITIVE;
    }

    public Mode setMode(CompoundTag tag, Mode mode) {
        tag.putString(TAG_MODE, mode.name());
        return mode;
    }

    public static BlockPos getPos(CompoundTag tag, String key) {
        return NbtUtils.readBlockPos((CompoundTag)tag.getCompound(key));
    }

    public String getOrCreateId(CompoundTag tag) {
        if (!tag.contains(TAG_PATTERN_ID)) {
            String id = RandomStringUtils.randomAlphanumeric((int)8).toUpperCase(Locale.ROOT);
            tag.putString(TAG_PATTERN_ID, id);
            return id;
        }
        return tag.getString(TAG_PATTERN_ID);
    }

    public CustomStructureSavedData getOrCreateData(ServerLevel level) {
        if (this.structureManager == null) {
            this.structureManager = (CustomStructureSavedData)level.getServer().overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(CustomStructureSavedData::new, tag -> {
                CustomStructureSavedData data = new CustomStructureSavedData();
                data.load((CompoundTag)tag);
                return data;
            }), "mffs_custom_structures");
        }
        return this.structureManager;
    }

    public Map<Vec3, BlockState> getFieldBlocks(Projector projector, ItemStack stack) {
        Level level = projector.be().getLevel();
        if (level instanceof ServerLevel) {
            String id;
            ServerLevel serverLevel = (ServerLevel)level;
            CompoundTag tag = stack.getOrCreateTag();
            CustomStructureSavedData data = this.getOrCreateData(serverLevel);
            CustomStructureSavedData.Structure structure = data.get(id = tag.getString(TAG_PATTERN_ID));
            if (structure != null) {
                return structure.getRealBlocks();
            }
        }
        return Map.of();
    }

    private static enum Mode {
        ADDITIVE,
        SUBTRACTIVE;

        private static final Mode[] VALUES;

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public MutableComponent getName() {
            return ModUtil.translate("item", "custom_mode.mode." + this.name().toLowerCase(Locale.ROOT), new Object[0]);
        }

        static {
            VALUES = Mode.values();
        }
    }

    public class CustomProjectorModeCapability
    implements ProjectorMode {
        private final ItemStack stack;

        public CustomProjectorModeCapability(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public Set<Vec3> getExteriorPoints(Projector projector) {
            return CustomProjectorModeItem.this.getFieldBlocks(projector, this.stack).keySet();
        }

        @Override
        public Set<Vec3> getInteriorPoints(Projector projector) {
            return this.getExteriorPoints(projector);
        }

        @Override
        public boolean isInField(Projector projector, Vec3 position) {
            return false;
        }
    }
}

