/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.su5ed.mffs.api.card.FrequencyCard;
import dev.su5ed.mffs.api.fortron.FortronStorage;
import dev.su5ed.mffs.item.BaseItem;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.util.ModUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FrequencyCardItem
extends BaseItem {
    private static final int MAX_FREQUENCY = 999999;

    public FrequencyCardItem() {
        super(new BaseItem.ExtendedItemProperties(new Item.Properties().stacksTo(1)).description());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack;
        FrequencyCard card;
        if (player.isShiftKeyDown() && (card = (FrequencyCard)(stack = player.getItemInHand(usedHand)).getCapability(ModCapabilities.FREQUENCY_CARD)) != null) {
            if (!level.isClientSide) {
                int frequency = level.random.nextInt(1000000);
                card.setFrequency(frequency);
                player.displayClientMessage((Component)ModUtil.translate("info", "frequency.generated", Component.literal((String)String.valueOf(frequency)).withStyle(ChatFormatting.AQUA)), true);
            }
            return InteractionResultHolder.consume((Object)stack);
        }
        return super.use(level, player, usedHand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        return Optional.ofNullable(level.getBlockEntity(context.getClickedPos())).map(be -> (FortronStorage)level.getCapability(ModCapabilities.FORTRON, be.getBlockPos(), be.getBlockState(), be, null)).map(fortron -> {
            if (!level.isClientSide) {
                int frequency = Objects.requireNonNull((FrequencyCard)stack.getCapability(ModCapabilities.FREQUENCY_CARD)).getFrequency();
                fortron.setFrequency(frequency);
                context.getPlayer().displayClientMessage((Component)ModUtil.translate("info", "frequency.set", Component.literal((String)String.valueOf(frequency)).withStyle(ChatFormatting.GREEN)), true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }).orElse(InteractionResult.PASS);
    }

    @Override
    public void appendHoverTextPre(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverTextPre(stack, level, tooltipComponents, isAdvanced);
        FrequencyCard card = (FrequencyCard)stack.getCapability(ModCapabilities.FREQUENCY_CARD);
        if (card != null) {
            tooltipComponents.add((Component)ModUtil.translate("info", "frequency", Component.literal((String)String.valueOf(card.getFrequency())).withStyle(ChatFormatting.GREEN)).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public static class FrequencyCardAttachment
    implements FrequencyCard {
        public static final Codec<FrequencyCardAttachment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("frequency").forGetter(FrequencyCardAttachment::getFrequency)).apply((Applicative)instance, FrequencyCardAttachment::new));
        private int frequency;

        public FrequencyCardAttachment() {
        }

        private FrequencyCardAttachment(int frequency) {
            this.frequency = frequency;
        }

        @Override
        public int getFrequency() {
            return this.frequency;
        }

        @Override
        public void setFrequency(int frequency) {
            this.frequency = frequency;
        }
    }
}

