/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.item;

import dev.su5ed.mffs.api.card.CoordLink;
import dev.su5ed.mffs.api.fortron.FortronStorage;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.item.BaseItem;
import dev.su5ed.mffs.menu.FortronMenu;
import dev.su5ed.mffs.render.particle.ParticleColor;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.util.Fortron;
import dev.su5ed.mffs.util.FrequencyGrid;
import dev.su5ed.mffs.util.ModUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RemoteControllerItem
extends BaseItem
implements CoordLink {
    public RemoteControllerItem() {
        super(new BaseItem.ExtendedItemProperties(new Item.Properties().stacksTo(1)).description());
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos pos;
        BlockEntity be;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (!level.isClientSide && player.isShiftKeyDown() && (be = level.getBlockEntity(pos = context.getClickedPos())) != null && level.getCapability(ModCapabilities.FORTRON, be.getBlockPos(), be.getBlockState(), be, null) != null) {
            this.setLink(stack, pos);
            BlockState state = level.getBlockState(pos);
            player.displayClientMessage((Component)ModUtil.translate("info", "link", state.getBlock().getName(), pos.toShortString()).withStyle(ChatFormatting.AQUA), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        BlockEntity be;
        BlockPos pos;
        ItemStack stack = player.getItemInHand(usedHand);
        if (!level.isClientSide && !player.isShiftKeyDown() && (pos = this.getLink(stack)) != null && level.isLoaded(pos) && (be = level.getBlockEntity(pos)) instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)be;
            if (Fortron.hasPermission(level, pos, FieldPermission.USE_BLOCKS, player) || Fortron.hasPermission(level, pos, FieldPermission.REMOTE_CONTROL, player)) {
                double requiredEnergy = ModUtil.distance(player.blockPosition(), pos) * 10.0;
                int frequency = Objects.requireNonNull((FortronStorage)level.getCapability(ModCapabilities.FORTRON, be.getBlockPos(), be.getBlockState(), be, null)).getFrequency();
                if (this.drawEnergy(level, player.blockPosition(), player.position().add(0.0, (double)player.getEyeHeight() - 0.2, 0.0), frequency, (int)requiredEnergy)) {
                    player.openMenu((MenuProvider)new RemoteMenuProvider(menuProvider), pos);
                    return InteractionResultHolder.success((Object)stack);
                }
                player.displayClientMessage((Component)ModUtil.translate("info", "cannot_harness", Math.round(requiredEnergy)).withStyle(ChatFormatting.RED), true);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public void appendHoverTextPre(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        BlockEntity be;
        BlockPos pos = this.getLink(stack);
        if (level != null && pos != null && (be = level.getBlockEntity(pos)) != null && level.getCapability(ModCapabilities.FORTRON, be.getBlockPos(), be.getBlockState(), be, null) != null) {
            tooltipComponents.add((Component)ModUtil.translate("info", "link", be.getBlockState().getBlock().getName().withStyle(ChatFormatting.GREEN), Component.literal((String)pos.toShortString()).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    @Override
    @Nullable
    public BlockPos getLink(ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        return NbtUtils.readBlockPos((CompoundTag)tag.getCompound("link"));
    }

    @Override
    public void setLink(ItemStack stack, BlockPos pos) {
        CompoundTag tag = stack.getOrCreateTag();
        tag.put("link", (Tag)NbtUtils.writeBlockPos((BlockPos)pos));
    }

    private boolean drawEnergy(Level level, BlockPos pos, Vec3 target, int frequency, int energy) {
        int required;
        List<FortronStorage> fortronTiles = FrequencyGrid.instance().get(level, (Vec3i)pos, 50, frequency);
        fortronTiles.sort(Comparator.comparingDouble(fortron -> fortron.getOwner().getBlockPos().distToCenterSqr((Position)target)));
        int total = 0;
        ArrayList<FortronStorage> transmitters = new ArrayList<FortronStorage>();
        for (FortronStorage fortron2 : fortronTiles) {
            int receivedEnergy = fortron2.extractFortron(required = energy - total, true);
            if (receivedEnergy > 0) {
                transmitters.add(fortron2);
            }
            if ((total += receivedEnergy) < energy) continue;
            break;
        }
        if (total >= energy) {
            total = 0;
            for (FortronStorage fortron2 : transmitters) {
                required = energy - total;
                total += fortron2.extractFortron(required, false);
                BlockPos fortronPos = fortron2.getOwner().getBlockPos();
                Fortron.renderClientBeam(level, target, Vec3.atCenterOf((Vec3i)fortronPos), fortronPos, ParticleColor.BLUE_BEAM, 20);
            }
            return true;
        }
        return false;
    }

    private record RemoteMenuProvider(MenuProvider wrapped) implements MenuProvider
    {
        public Component getDisplayName() {
            return this.wrapped.getDisplayName();
        }

        @Nullable
        public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
            AbstractContainerMenu menu = this.wrapped.createMenu(containerId, playerInventory, player);
            if (menu instanceof FortronMenu) {
                FortronMenu fortronMenu = (FortronMenu)menu;
                fortronMenu.setRemoteAccess(true);
            }
            return menu;
        }
    }
}

