/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.network;

import dev.su5ed.mffs.blockentity.ProjectorBlockEntity;
import dev.su5ed.mffs.network.DrawBeamPacket;
import dev.su5ed.mffs.network.DrawHologramPacket;
import dev.su5ed.mffs.network.Network;
import dev.su5ed.mffs.network.SetStructureShapePacket;
import dev.su5ed.mffs.network.UpdateAnimationSpeed;
import dev.su5ed.mffs.network.UpdateBlockEntityPacket;
import dev.su5ed.mffs.render.CustomProjectorModeClientHandler;
import dev.su5ed.mffs.render.particle.BeamParticleOptions;
import dev.su5ed.mffs.render.particle.MovingHologramParticleOptions;
import dev.su5ed.mffs.render.particle.ParticleColor;
import dev.su5ed.mffs.setup.ModObjects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public final class ClientPacketHandler {
    public static void handleDrawBeamPacket(DrawBeamPacket packet, PlayPayloadContext ctx) {
        Minecraft minecraft = Minecraft.getInstance();
        Vec3 pos = packet.position();
        minecraft.level.addParticle((ParticleOptions)new BeamParticleOptions(packet.target(), packet.color(), packet.lifetime()), pos.x(), pos.y(), pos.z(), 0.0, 0.0, 0.0);
    }

    public static void handleSetStructureShapePacket(SetStructureShapePacket packet, PlayPayloadContext ctx) {
        CustomProjectorModeClientHandler.setShape(packet.level(), packet.structId(), packet.shape());
    }

    public static void handleUpdateAnimationSpeedPacket(UpdateAnimationSpeed packet, PlayPayloadContext ctx) {
        Network.findBlockEntity(ProjectorBlockEntity.class, (Level)Minecraft.getInstance().level, packet.pos()).ifPresent(be -> be.setClientAnimationSpeed(packet.animationSpeed()));
    }

    public static void handleDrawHologramPacket(DrawHologramPacket packet, PlayPayloadContext ctx) {
        Minecraft minecraft = Minecraft.getInstance();
        DrawHologramPacket.Type type = packet.type();
        Vec3 pos = packet.pos().add(0.5, 0.5, 0.5);
        Vec3 target = packet.target();
        Vec3 targetCenter = packet.target().add(0.5, 0.5, 0.5);
        if (type == DrawHologramPacket.Type.CONSTRUCT) {
            minecraft.level.addParticle((ParticleOptions)new BeamParticleOptions(targetCenter, ParticleColor.BLUE_BEAM, 40), pos.x(), pos.y(), pos.z(), 0.0, 0.0, 0.0);
            minecraft.level.addParticle((ParticleOptions)new MovingHologramParticleOptions(ParticleColor.BLUE_FIELD, 40), target.x(), target.y(), target.z(), 0.0, 0.0, 0.0);
        } else if (type == DrawHologramPacket.Type.DESTROY) {
            minecraft.level.addParticle((ParticleOptions)new BeamParticleOptions(targetCenter, ParticleColor.RED, 40), pos.x(), pos.y(), pos.z(), 0.0, 0.0, 0.0);
            minecraft.level.addParticle((ParticleOptions)new MovingHologramParticleOptions(ParticleColor.RED, 40), target.x(), target.y(), target.z(), 0.0, 0.0, 0.0);
        }
    }

    public static void handleBlockEntityUpdatePacket(UpdateBlockEntityPacket packet, PlayPayloadContext ctx) {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.level.getBlockEntity(packet.pos(), (BlockEntityType)ModObjects.FORCE_FIELD_BLOCK_ENTITY.get()).ifPresent(be -> be.handleCustomUpdateTag(packet.data()));
    }

    private ClientPacketHandler() {
    }
}

