/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.network;

import dev.su5ed.mffs.MFFSMod;
import dev.su5ed.mffs.item.CustomProjectorModeItem;
import dev.su5ed.mffs.network.SetStructureShapePacket;
import dev.su5ed.mffs.setup.ModItems;
import dev.su5ed.mffs.util.projector.CustomStructureSavedData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record StructureDataRequestPacket(String structId) implements CustomPacketPayload
{
    public static final ResourceLocation ID = MFFSMod.location("structure_data");

    public StructureDataRequestPacket(FriendlyByteBuf buf) {
        this(buf.readUtf());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.structId);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ServerLevel level = (ServerLevel)((Player)ctx.player().orElseThrow()).level();
        CustomStructureSavedData data = ((CustomProjectorModeItem)((Object)ModItems.CUSTOM_MODE.get())).getOrCreateData(level);
        CustomStructureSavedData.Structure structure = data.get(this.structId);
        ctx.replyHandler().send((CustomPacketPayload)new SetStructureShapePacket((ResourceKey<Level>)level.dimension(), this.structId, structure != null ? structure.shape() : null));
    }
}

