/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.network;

import dev.su5ed.mffs.MFFSMod;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.blockentity.BiometricIdentifierBlockEntity;
import dev.su5ed.mffs.network.Network;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record ToggleFieldPermissionPacket(BlockPos pos, FieldPermission permission, boolean value) implements CustomPacketPayload
{
    public static final ResourceLocation ID = MFFSMod.location("toggle_field_permission");

    public ToggleFieldPermissionPacket(FriendlyByteBuf buf) {
        this(buf.readBlockPos(), (FieldPermission)buf.readEnum(FieldPermission.class), buf.readBoolean());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeEnum((Enum)this.permission);
        buf.writeBoolean(this.value);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        Level level = ((Player)ctx.player().orElseThrow()).level();
        Network.findBlockEntity(BiometricIdentifierBlockEntity.class, level, this.pos).flatMap(BiometricIdentifierBlockEntity::getManipulatingCard).ifPresent(card -> {
            if (this.value) {
                card.addPermission(this.permission);
            } else {
                card.removePermission(this.permission);
            }
        });
    }
}

