/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.su5ed.mffs.blockentity.BiometricIdentifierBlockEntity;
import dev.su5ed.mffs.render.ModRenderType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class BiometricIdentifierRenderer
implements BlockEntityRenderer<BiometricIdentifierBlockEntity> {
    public static final ResourceLocation HOLO_SCREEN_TEXTURE = new ResourceLocation("mffs", "model/holo_screen");
    private static final RenderType RENDER_TYPE = ModRenderType.POS_COL_TEX_TRANSLUCENT_UNCULLED_QUAD.apply(InventoryMenu.BLOCK_ATLAS);

    public BiometricIdentifierRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BiometricIdentifierBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.hasLevel() && blockEntity.isActive()) {
            BlockState state = blockEntity.getBlockState();
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose(Axis.YN.rotationDegrees(facing.toYRot()));
            poseStack.mulPose(Axis.XP.rotationDegrees(25.0f));
            float offset = 0.4f * (0.5f - BiometricIdentifierRenderer.quadraticCurve(Math.min(0.05f + (float)blockEntity.getAnimation() / 50.0f, 0.5f)));
            float alpha = Math.max(0.0f, Math.min(-1.0f + (float)blockEntity.getAnimation() / 4.0f, 1.0f));
            poseStack.translate(-0.5, -0.65 - (double)offset, -0.5 - (double)offset * 0.6);
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.scale(0.85f, 0.85f, 0.85f);
            poseStack.translate(-0.5, -0.5, -0.5);
            Matrix4f mat = poseStack.last().pose();
            VertexConsumer screenConsumer = bufferSource.getBuffer(RENDER_TYPE);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(HOLO_SCREEN_TEXTURE);
            screenConsumer.vertex(mat, 0.0f, 1.0f, 1.0f).color(1.0f, 1.0f, 1.0f, alpha).uv(sprite.getU0(), sprite.getV1()).endVertex();
            screenConsumer.vertex(mat, 1.0f, 1.0f, 1.0f).color(1.0f, 1.0f, 1.0f, alpha).uv(sprite.getU1(), sprite.getV1()).endVertex();
            screenConsumer.vertex(mat, 1.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, alpha).uv(sprite.getU1(), sprite.getV0()).endVertex();
            screenConsumer.vertex(mat, 0.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, alpha).uv(sprite.getU0(), sprite.getV0()).endVertex();
            poseStack.popPose();
        }
    }

    private static float quadraticCurve(float t) {
        return 2.0f * t * (1.0f - t);
    }
}

