/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.su5ed.mffs.util.ModUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.lwjgl.opengl.GL11;

public final class BlockHighlighter {
    private static final float OUTLINE_WIDTH = 1.0f;
    private static final Color OUTLINE_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.5f);
    public static final Color LIGHT_GREEN = new Color(0.0f, 1.0f, 0.0f, 0.15f);
    public static final Color LIGHT_RED = new Color(1.0f, 0.0f, 0.0f, 0.25f);

    public static void highlightBlock(PoseStack pose, Vec3 cameraPos, BlockPos pos, Color color) {
        BlockHighlighter.highlightArea(pose, cameraPos, Shapes.create((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)), color);
    }

    public static void highlightArea(PoseStack pose, Vec3 cameraPos, BlockPos from, BlockPos to) {
        BlockPos normalFrom = ModUtil.normalize(from, to);
        AABB area = AABB.encapsulatingFullBlocks((BlockPos)normalFrom, (BlockPos)ModUtil.normalize(to, normalFrom));
        VoxelShape shape = Shapes.create((AABB)area);
        BlockHighlighter.highlightArea(pose, cameraPos, shape, null);
    }

    public static void highlightArea(PoseStack pose, Vec3 cameraPos, VoxelShape shape, @Nullable Color fillColor) {
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        pose.pushPose();
        pose.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        if (fillColor != null) {
            BlockHighlighter.drawOutlineBoxes(tessellator, pose, buffer, fillColor, shape);
        }
        BlockHighlighter.drawOutlineLines(tessellator, pose, buffer, OUTLINE_COLOR, shape);
        pose.popPose();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
    }

    private static void drawOutlineBoxes(Tesselator tessellator, PoseStack matrices, BufferBuilder buffer, Color color, VoxelShape outline) {
        PoseStack.Pose entry = matrices.last();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        outline.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> BlockHighlighter.drawBox(entry, buffer, (float)(minX -= 0.001), (float)(minY -= 0.001), (float)(minZ -= 0.001), (float)(maxX += 0.001), (float)(maxY += 0.001), (float)(maxZ += 0.001), color));
        tessellator.end();
    }

    private static void drawOutlineLines(Tesselator tessellator, PoseStack matrices, BufferBuilder buffer, Color color, VoxelShape outline) {
        GL11.glEnable((int)2848);
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        RenderSystem.lineWidth((float)1.0f);
        buffer.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        BlockHighlighter.drawOutlineLine(tessellator, matrices.last(), buffer, color, outline);
        GL11.glDisable((int)2848);
    }

    private static void drawOutlineLine(Tesselator tessellator, PoseStack.Pose entry, BufferBuilder buffer, Color color, VoxelShape outline) {
        outline.forAllEdges((minX, minY, minZ, maxX, maxY, maxZ) -> BlockHighlighter.drawLine(entry, buffer, new Vector3d(minX -= 0.001, minY -= 0.001, minZ -= 0.001), new Vector3d(maxX += 0.001, maxY += 0.001, maxZ += 0.001), color));
        tessellator.end();
    }

    private static void drawBox(PoseStack.Pose entry, BufferBuilder buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color color) {
        Matrix4f position = entry.pose();
        float r = color.red();
        float g = color.green();
        float b = color.blue();
        float a = color.alpha();
        buffer.vertex(position, minX, minY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, minX, minY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, minX, maxY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, minX, maxY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, maxX, minY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, maxX, minY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, maxX, maxY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, maxX, maxY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, maxX, minY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, minX, minY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, minX, maxY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, maxX, maxY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, minX, minY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, maxX, minY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, maxX, maxY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, minX, maxY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, minX, maxY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, maxX, maxY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, maxX, maxY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, minX, maxY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, maxX, minY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, minX, minY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, minX, minY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(position, maxX, minY, minZ).color(r, g, b, a).endVertex();
    }

    private static Vector3d getNormalAngle(Vector3d start, Vector3d end) {
        double xLength = end.x - start.x;
        double yLength = end.y - start.y;
        double zLength = end.z - start.z;
        double distance = Math.sqrt(xLength * xLength + yLength * yLength + zLength * zLength);
        return new Vector3d(xLength /= distance, yLength /= distance, zLength /= distance);
    }

    private static void drawLine(PoseStack.Pose entry, BufferBuilder buffer, Vector3d start, Vector3d end, Color color) {
        Vector3d normal = BlockHighlighter.getNormalAngle(start, end);
        float red = color.red();
        float green = color.green();
        float blue = color.blue();
        float alpha = color.alpha();
        buffer.vertex(entry.pose(), (float)start.x, (float)start.y, (float)start.z).color(red, green, blue, alpha).normal(entry.normal(), (float)normal.x, (float)normal.y, (float)normal.z).endVertex();
        buffer.vertex(entry.pose(), (float)end.x, (float)end.y, (float)end.z).color(red, green, blue, alpha).normal(entry.normal(), (float)normal.x, (float)normal.y, (float)normal.z).endVertex();
    }

    private BlockHighlighter() {
    }

    public record Color(float red, float green, float blue, float alpha) {
        public Color withAlpha(float alpha) {
            return new Color(this.red, this.green, this.blue, alpha);
        }
    }
}

