/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.su5ed.mffs.item.CustomProjectorModeItem;
import dev.su5ed.mffs.network.StructureDataRequestPacket;
import dev.su5ed.mffs.render.BlockHighlighter;
import dev.su5ed.mffs.setup.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import one.util.streamex.StreamEx;

@Mod.EventBusSubscriber(modid="mffs", value={Dist.CLIENT})
public final class CustomProjectorModeClientHandler {
    private static final float MIN_ALPHA = 0.1f;
    private static final float MAX_ALPHA = BlockHighlighter.LIGHT_RED.alpha();
    private static final int PERIOD_TICKS = 30;
    private static final Map<ResourceKey<Level>, Map<String, VoxelShape>> STRUCTURE_SHAPES = new HashMap<ResourceKey<Level>, Map<String, VoxelShape>>();

    public static VoxelShape getOrRequestShape(ItemStack stack, Level level) {
        String id = stack.getOrCreateTag().getString("pattern_id");
        ResourceKey key = level.dimension();
        Map<String, VoxelShape> map = STRUCTURE_SHAPES.get(key);
        if (map == null || !map.containsKey(id)) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new StructureDataRequestPacket(id)});
            CustomProjectorModeClientHandler.setShape((ResourceKey<Level>)key, id, null);
            return null;
        }
        return map.get(id);
    }

    public static void setShape(ResourceKey<Level> level, String id, VoxelShape shape) {
        Map map = STRUCTURE_SHAPES.computeIfAbsent(level, l -> new HashMap());
        map.put(id, shape);
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            Minecraft minecraft = Minecraft.getInstance();
            StreamEx.of((Object[])new ItemStack[]{minecraft.player.getMainHandItem(), minecraft.player.getOffhandItem()}).findFirst(stack -> stack.is((Item)ModItems.CUSTOM_MODE.get())).ifPresent(stack -> {
                VoxelShape shape;
                PoseStack pose = new PoseStack();
                Vec3 cameraPos = event.getCamera().getPosition();
                CompoundTag tag = stack.getOrCreateTag();
                if (tag.contains("primary_point")) {
                    BlockPos primary = CustomProjectorModeItem.getPos(tag, "primary_point");
                    BlockHighlighter.highlightBlock(pose, cameraPos, primary, BlockHighlighter.LIGHT_GREEN);
                    if (tag.contains("secondary_point")) {
                        BlockPos secondary = CustomProjectorModeItem.getPos(tag, "secondary_point");
                        BlockHighlighter.highlightBlock(pose, cameraPos, secondary, BlockHighlighter.LIGHT_RED);
                        BlockHighlighter.highlightArea(pose, cameraPos, primary, secondary);
                    } else {
                        HitResult patt3715$temp = minecraft.hitResult;
                        if (patt3715$temp instanceof BlockHitResult) {
                            BlockHitResult blockHitResult = (BlockHitResult)patt3715$temp;
                            BlockPos secondary = blockHitResult.getBlockPos();
                            float alpha = 0.1f + (MAX_ALPHA - 0.1f) * 0.5f * Mth.abs((float)(Mth.sin((float)(0.20943953f * (float)event.getRenderTick())) + 1.0f));
                            BlockHighlighter.highlightBlock(pose, cameraPos, secondary, BlockHighlighter.LIGHT_RED.withAlpha(alpha));
                            BlockHighlighter.highlightArea(pose, cameraPos, primary, secondary);
                        }
                    }
                }
                if (tag.contains("pattern_id") && (shape = CustomProjectorModeClientHandler.getOrRequestShape(stack, (Level)minecraft.level)) != null) {
                    BlockHighlighter.highlightArea(pose, cameraPos, shape, null);
                }
            });
        }
    }

    private CustomProjectorModeClientHandler() {
    }
}

