/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.screen;

import dev.su5ed.mffs.blockentity.FortronBlockEntity;
import dev.su5ed.mffs.menu.FortronMenu;
import dev.su5ed.mffs.network.ToggleModePacket;
import dev.su5ed.mffs.network.UpdateFrequencyPacket;
import dev.su5ed.mffs.screen.BaseScreen;
import dev.su5ed.mffs.screen.FortronChargeWidget;
import dev.su5ed.mffs.screen.NumericEditBox;
import dev.su5ed.mffs.screen.ToggleButton;
import dev.su5ed.mffs.util.ModUtil;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class FortronScreen<T extends FortronMenu<?>>
extends BaseScreen<T> {
    protected IntIntPair frequencyBoxPos = IntIntPair.of((int)0, (int)0);
    protected IntIntPair frequencyLabelPos = IntIntPair.of((int)0, (int)0);
    protected IntIntPair fortronEnergyBarPos = IntIntPair.of((int)0, (int)0);
    protected int fortronEnergyBarWidth;
    private NumericEditBox frequency;

    public FortronScreen(T menu, Inventory playerInventory, Component title, ResourceLocation background) {
        super(menu, playerInventory, title, background);
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ToggleButton(this.width / 2 - 82, this.height / 2 - 104, () -> ((FortronMenu)this.menu).blockEntity.isActive(), () -> PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ToggleModePacket(((FortronMenu)this.menu).blockEntity.getBlockPos(), !((FortronBlockEntity)((FortronMenu)this.menu).blockEntity).isActive())})));
        this.frequency = new NumericEditBox(this.font, this.leftPos + this.frequencyBoxPos.leftInt(), this.topPos + this.frequencyBoxPos.rightInt(), 50, 12, (Component)ModUtil.translate("screen", "frequency", new Object[0]));
        this.frequency.setCanLoseFocus(true);
        this.frequency.setBordered(true);
        this.frequency.setEditable(true);
        this.frequency.setMaxLength(6);
        this.updateFrequencyValue();
        this.addWidget((GuiEventListener)this.frequency);
        ((FortronMenu)this.menu).setFrequencyChangeListener(this::updateFrequencyValue);
        this.addRenderableWidget((GuiEventListener)new FortronChargeWidget(this.leftPos + this.fortronEnergyBarPos.leftInt(), this.topPos + this.fortronEnergyBarPos.rightInt(), this.fortronEnergyBarWidth, 11, (Component)Component.empty(), () -> (double)((FortronBlockEntity)((FortronMenu)this.menu).blockEntity).fortronStorage.getStoredFortron() / (double)((FortronBlockEntity)((FortronMenu)this.menu).blockEntity).fortronStorage.getFortronCapacity()));
    }

    private void updateFrequencyValue() {
        this.frequency.setResponder(null);
        this.frequency.setValue(Integer.toString(((FortronBlockEntity)((FortronMenu)this.menu).blockEntity).fortronStorage.getFrequency()));
        this.frequency.setResponder(this::onFrequencyChanged);
    }

    @Override
    public void renderFg(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.frequency.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        this.drawWithTooltip(guiGraphics, (float)this.frequencyLabelPos.leftInt(), (float)this.frequencyLabelPos.rightInt(), 0x404040, this.frequency.getMessage(), (Component)ModUtil.translate("screen", "frequency.tooltip", new Object[0]));
    }

    private void onFrequencyChanged(String str) {
        int frequency = str.isEmpty() ? 0 : Integer.parseInt(str);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new UpdateFrequencyPacket(((FortronMenu)this.menu).blockEntity.getBlockPos(), frequency)});
    }
}

