/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class IconCycleButton<T extends Enum<T>>
extends AbstractButton {
    public static final ResourceLocation GUI_BUTTONS = new ResourceLocation("mffs", "textures/gui/buttons.png");
    private final ResourceLocation image;
    private final int imageU;
    private final int imageV;
    private final int yStep;
    private final Supplier<T> value;
    private final Consumer<T> onPress;

    public IconCycleButton(int x, int y, int width, int height, int imageU, int imageV, int yStep, Supplier<T> value, Consumer<T> onPress) {
        this(x, y, width, height, GUI_BUTTONS, imageU, imageV, yStep, value, onPress);
    }

    public IconCycleButton(int x, int y, int width, int height, ResourceLocation image, int imageU, int imageV, int yStep, Supplier<T> value, Consumer<T> onPress) {
        super(x, y, width, height, (Component)Component.empty());
        this.image = image;
        this.imageU = imageU;
        this.imageV = imageV;
        this.yStep = yStep;
        this.value = value;
        this.onPress = onPress;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isHovered) {
            guiGraphics.setColor(0.85f, 0.85f, 0.85f, this.alpha);
        } else {
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        int vOffset = this.imageV + ((Enum)this.value.get()).ordinal() * this.yStep;
        guiGraphics.blit(this.image, this.getX(), this.getY(), this.imageU, vOffset, this.width, this.height);
        guiGraphics.blit(this.image, this.getX() + this.width / 2, this.getY(), 200 - this.width / 2, vOffset, this.width / 2, this.height);
    }

    public void onPress() {
        this.onPress.accept((Enum)this.value.get());
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }
}

