/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.inventory;

import dev.su5ed.mffs.util.inventory.InventorySlotItemHandler;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class InventorySlot
implements INBTSerializable<CompoundTag> {
    private final InventorySlotItemHandler parent;
    private final String name;
    private final Mode mode;
    private final Predicate<ItemStack> filter;
    private final Consumer<ItemStack> onChanged;
    private ItemStack content = ItemStack.EMPTY;

    public InventorySlot(InventorySlotItemHandler parent, String name, Mode mode, Predicate<ItemStack> filter, Consumer<ItemStack> onChanged) {
        this.parent = parent;
        this.name = name;
        this.mode = mode;
        this.filter = filter;
        this.onChanged = onChanged;
    }

    public String getName() {
        return this.name;
    }

    public boolean canInsert(ItemStack stack) {
        return this.mode.input && this.accepts(stack);
    }

    public boolean canExtract() {
        return this.mode.output;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public ItemStack getItem() {
        return this.content;
    }

    public void setItem(ItemStack stack) {
        this.setItem(stack, true);
    }

    public void setItem(ItemStack stack, boolean notify) {
        this.content = stack;
        this.onChanged(notify);
    }

    public ItemStack insert(ItemStack stack, boolean simulate) {
        if (!stack.isEmpty() && this.canAdd(stack)) {
            int remainder;
            if (this.content.isEmpty()) {
                if (!simulate) {
                    this.setItem(stack);
                }
                return ItemStack.EMPTY;
            }
            if (!simulate) {
                int total = Math.min(this.content.getCount() + stack.getCount(), this.content.getMaxStackSize());
                this.content.setCount(total);
            }
            ItemStack result = (remainder = this.content.getCount() + stack.getCount() - this.content.getMaxStackSize()) > 0 ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remainder) : ItemStack.EMPTY;
            this.onChanged(true);
            return result;
        }
        return stack;
    }

    public boolean accepts(ItemStack stack) {
        return this.filter.test(stack);
    }

    public ItemStack extract(int amount, boolean simulate) {
        if (this.canExtract()) {
            if (!simulate) {
                ItemStack stack = this.content.split(amount);
                this.onChanged(true);
                return stack;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)this.content, (int)Math.min(amount, this.content.getCount()));
        }
        return ItemStack.EMPTY;
    }

    protected void onChanged(boolean notify) {
        if (notify) {
            this.parent.onChanged();
            this.onChanged.accept(this.getItem());
        }
    }

    private boolean canAdd(ItemStack stack) {
        return this.accepts(stack) && (this.content.isEmpty() || ItemHandlerHelper.canItemStacksStack((ItemStack)this.content, (ItemStack)stack));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.content.save(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.content = ItemStack.of((CompoundTag)nbt);
    }

    public static enum Mode {
        INPUT(true, false),
        OUTPUT(false, true),
        BOTH(true, true),
        NONE(false, false);

        private final boolean input;
        private final boolean output;

        private Mode(boolean input, boolean output) {
            this.input = input;
            this.output = output;
        }
    }
}

