/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.module;

import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.Module;
import dev.su5ed.mffs.api.module.ModuleType;
import dev.su5ed.mffs.blockentity.ProjectorBlockEntity;
import dev.su5ed.mffs.network.DrawHologramPacket;
import dev.su5ed.mffs.setup.ModModules;
import dev.su5ed.mffs.setup.ModTags;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.module.BaseModule;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class DisintegrationModule
extends BaseModule {
    private final List<BlockPos> activeBlocks = new ArrayList<BlockPos>();

    public DisintegrationModule(ModuleType<?> type, ItemStack stack) {
        super(type, stack);
    }

    @Override
    public Module.ProjectAction onSelect(Projector projector, BlockPos pos) {
        Level level;
        BlockState state;
        if (!this.activeBlocks.contains(pos) && !(state = (level = projector.be().getLevel()).getBlockState(pos)).isAir()) {
            Block block = state.getBlock();
            if (projector.hasModule(ModModules.CAMOUFLAGE)) {
                Item blockItem = block.asItem();
                if (projector.getAllModuleItemsStream().noneMatch(stack -> ProjectorBlockEntity.getFilterBlock(stack).isPresent() && stack.is(blockItem))) {
                    return Module.ProjectAction.SKIP;
                }
            }
            if (!state.is(ModTags.DISINTEGRATION_BLACKLIST) && !ModUtil.isLiquidBlock(block)) {
                if (this.activeBlocks.size() - 1 >= projector.getModuleCount(ModModules.SPEED) / 3) {
                    return Module.ProjectAction.INTERRUPT;
                }
                this.activeBlocks.add(pos);
                return Module.ProjectAction.PROJECT;
            }
        }
        return Module.ProjectAction.SKIP;
    }

    @Override
    public Module.ProjectAction onProject(Projector projector, BlockPos position) {
        Level level = projector.be().getLevel();
        BlockState state = level.getBlockState(position);
        Vec3 pos = Vec3.atLowerCornerOf((Vec3i)projector.be().getBlockPos());
        Vec3 target = Vec3.atLowerCornerOf((Vec3i)position);
        PacketDistributor.TRACKING_CHUNK.with((Object)level.getChunkAt(position)).send(new CustomPacketPayload[]{new DrawHologramPacket(pos, target, DrawHologramPacket.Type.DESTROY)});
        projector.schedule(39, () -> {
            if (projector.hasModule(ModModules.COLLECTION)) {
                DisintegrationModule.collectBlock(projector, level, position, state.getBlock());
            } else {
                DisintegrationModule.destroyBlock(level, position, state.getBlock());
            }
            this.activeBlocks.remove(position);
        });
        return Module.ProjectAction.SKIP;
    }

    private static void destroyBlock(Level level, BlockPos pos, Block block) {
        BlockState state = level.getBlockState(pos);
        if (state.is(block)) {
            Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
            level.removeBlock(pos, false);
        }
    }

    private static void collectBlock(Projector projector, Level level, BlockPos pos, Block block) {
        BlockState state = level.getBlockState(pos);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (state.is(block)) {
                Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos)).forEach(projector::mergeIntoInventory);
                level.removeBlock(pos, false);
            }
        }
    }
}

