/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.module;

import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.Module;
import dev.su5ed.mffs.api.module.ModuleType;
import dev.su5ed.mffs.network.DrawHologramPacket;
import dev.su5ed.mffs.setup.ModModules;
import dev.su5ed.mffs.setup.ModTags;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.module.BaseModule;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class StabilizationModule
extends BaseModule {
    private int blockCount = 0;

    public StabilizationModule(ModuleType<?> type, ItemStack stack) {
        super(type, stack);
    }

    @Override
    public void beforeProject(Projector projector) {
        this.blockCount = 0;
    }

    @Override
    public Module.ProjectAction onProject(Projector projector, BlockPos position) {
        if (projector.getTicks() % 40L == 0L) {
            Level level = projector.be().getLevel();
            BlockPos pos = projector.be().getBlockPos();
            for (Direction side : Direction.values()) {
                IItemHandler handler = Optional.ofNullable(level.getBlockEntity(pos.relative(side))).map(neighbor -> (IItemHandler)neighbor.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, neighbor.getBlockPos(), neighbor.getBlockState(), neighbor, (Object)side)).orElse(null);
                if (handler == null) continue;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    BlockItem blockItem;
                    Block block;
                    BlockState state;
                    ItemStack stack = handler.extractItem(i, 1, true);
                    Item item = stack.getItem();
                    if (!(item instanceof BlockItem) || (state = (block = (blockItem = (BlockItem)item).getBlock()).defaultBlockState()).is(ModTags.STABILIZATION_BLACKLIST) || ModUtil.isLiquidBlock(block) || !level.setBlockAndUpdate(position, state)) continue;
                    handler.extractItem(i, 1, false);
                    Vec3 start = Vec3.atLowerCornerOf((Vec3i)pos);
                    Vec3 target = Vec3.atLowerCornerOf((Vec3i)position);
                    PacketDistributor.TRACKING_CHUNK.with((Object)level.getChunkAt(position)).send(new CustomPacketPayload[]{new DrawHologramPacket(start, target, DrawHologramPacket.Type.CONSTRUCT)});
                    return this.blockCount++ >= projector.getModuleCount(ModModules.SPEED) / 3 ? Module.ProjectAction.INTERRUPT : Module.ProjectAction.SKIP;
                }
            }
        }
        return Module.ProjectAction.SKIP;
    }
}

