/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.projector;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.su5ed.mffs.network.SetStructureShapePacket;
import dev.su5ed.mffs.util.ModUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class CustomStructureSavedData
extends SavedData {
    public static final String NAME = "mffs_custom_structures";
    public static final Codec<AABB> AABB_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("minX").forGetter(a -> a.minX), (App)Codec.DOUBLE.fieldOf("minY").forGetter(a -> a.minY), (App)Codec.DOUBLE.fieldOf("minZ").forGetter(a -> a.minZ), (App)Codec.DOUBLE.fieldOf("maxX").forGetter(a -> a.maxX), (App)Codec.DOUBLE.fieldOf("maxY").forGetter(a -> a.maxY), (App)Codec.DOUBLE.fieldOf("maxZ").forGetter(a -> a.maxZ)).apply((Applicative)instance, AABB::new));
    public static final Codec<VoxelShape> VOXEL_SHAPE_CODEC = AABB_CODEC.listOf().xmap(CustomStructureSavedData::shapeFromAABBs, VoxelShape::toAabbs);
    public static final Codec<Map<String, Structure>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, Structure.CODEC);
    private final Map<String, Structure> structures = new HashMap<String, Structure>();

    @Nullable
    public Structure get(String id) {
        return this.structures.get(id);
    }

    public void clear(Level level, ServerPlayer serverPlayer, String id) {
        this.structures.remove(id);
        CustomStructureSavedData.sendToClient((ResourceKey<Level>)level.dimension(), id, null, serverPlayer);
    }

    private Structure getOrCreate(String id) {
        return this.structures.computeIfAbsent(id, s -> new Structure());
    }

    public void join(String id, Level level, ServerPlayer serverPlayer, BlockPos min, BlockPos max, boolean add) {
        Structure structure = this.getOrCreate(id);
        BooleanOp op = add ? BooleanOp.OR : BooleanOp.ONLY_FIRST;
        BlockPos normalFrom = ModUtil.normalize(min, max);
        VoxelShape normalShape = Shapes.joinUnoptimized((VoxelShape)structure.normalShape, (VoxelShape)Shapes.create((AABB)AABB.encapsulatingFullBlocks((BlockPos)normalFrom, (BlockPos)ModUtil.normalize(max, normalFrom))), (BooleanOp)op);
        VoxelShape shape = Shapes.joinUnoptimized((VoxelShape)structure.shape, (VoxelShape)Shapes.create((AABB)AABB.encapsulatingFullBlocks((BlockPos)min, (BlockPos)CustomStructureSavedData.normalizeAxis(min, max))), (BooleanOp)op);
        AABB area = AABB.encapsulatingFullBlocks((BlockPos)min, (BlockPos)max);
        int x = (int)area.minX;
        while ((double)x <= area.maxX) {
            int y = (int)area.minY;
            while ((double)y <= area.maxY) {
                int z = (int)area.minZ;
                while ((double)z <= area.maxZ) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.getBlockState(pos);
                    if (!state.isAir()) {
                        if (add) {
                            structure.blocks.put(pos, state);
                        } else {
                            structure.blocks.remove(pos);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        Structure newStruct = new Structure(shape, normalShape, structure.blocks);
        this.structures.put(id, newStruct);
        this.setDirty();
        CustomStructureSavedData.sendToClient((ResourceKey<Level>)level.dimension(), id, normalShape, serverPlayer);
    }

    private static void sendToClient(ResourceKey<Level> key, String id, VoxelShape shape, ServerPlayer player) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new SetStructureShapePacket(key, id, shape)});
    }

    private static BlockPos normalizeAxis(BlockPos min, BlockPos max) {
        if (min.getX() == max.getX()) {
            max = max.east();
        }
        if (min.getY() == max.getY()) {
            max = max.above();
        }
        if (min.getZ() == max.getZ()) {
            max = max.south();
        }
        return max;
    }

    public void remove(String id, BlockPos pos) {
        Structure structure = this.get(id);
        if (structure != null) {
            structure.blocks.remove(pos);
            this.setDirty();
        }
    }

    public void load(CompoundTag tag) {
        Tag structuresTag = tag.get("structures");
        this.structures.putAll((Map)((Pair)CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)structuresTag).getOrThrow(false, s -> {})).getFirst());
    }

    public CompoundTag save(CompoundTag tag) {
        Tag structuresTag = (Tag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.structures).getOrThrow(false, s -> {});
        tag.put("structures", structuresTag);
        return tag;
    }

    public static VoxelShape shapeFromAABBs(List<AABB> aabbs) {
        VoxelShape shape = Shapes.empty();
        for (AABB area : aabbs) {
            VoxelShape partial = Shapes.create((AABB)area);
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)partial, (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    public static class Structure {
        public static final Codec<Map<BlockPos, BlockState>> BLOCK_MAP_CODEC = Codec.pair((Codec)BlockPos.CODEC.fieldOf("pos").codec(), (Codec)BlockState.CODEC.fieldOf("state").codec()).listOf().xmap(pairs -> StreamEx.of((Collection)pairs).mapToEntry(Pair::getFirst, Pair::getSecond).toMap(), map -> EntryStream.of((Map)map).mapKeyValue(Pair::of).toList());
        public static final Codec<Structure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VOXEL_SHAPE_CODEC.fieldOf("shape").forGetter(Structure::shape), (App)VOXEL_SHAPE_CODEC.fieldOf("normalShape").forGetter(Structure::normalShape), (App)BLOCK_MAP_CODEC.fieldOf("blocks").forGetter(Structure::blocks)).apply((Applicative)instance, Structure::new));
        private final VoxelShape shape;
        private final VoxelShape normalShape;
        private final Map<BlockPos, BlockState> blocks;
        private final Supplier<Map<BlockPos, BlockState>> relativeBlocks = Suppliers.memoize(this::computeRelativeBlocks);
        @Nullable
        private Map<Vec3, BlockState> realBlocks;

        public Structure() {
            this(Shapes.empty(), Shapes.empty(), new HashMap<BlockPos, BlockState>());
        }

        public Structure(VoxelShape shape, VoxelShape normalShape, Map<BlockPos, BlockState> blocks) {
            this.shape = shape;
            this.normalShape = normalShape;
            this.blocks = blocks;
        }

        public VoxelShape shape() {
            return this.shape;
        }

        public VoxelShape normalShape() {
            return this.normalShape;
        }

        public Map<BlockPos, BlockState> blocks() {
            return this.blocks;
        }

        public Map<BlockPos, BlockState> getRelativeBlocks() {
            return this.relativeBlocks.get();
        }

        public Map<Vec3, BlockState> getRealBlocks() {
            if (this.realBlocks == null) {
                HashMap<Vec3, BlockState> map = new HashMap<Vec3, BlockState>();
                for (Map.Entry<BlockPos, BlockState> entry : this.getRelativeBlocks().entrySet()) {
                    map.put(Vec3.atLowerCornerOf((Vec3i)((Vec3i)entry.getKey())), entry.getValue());
                }
                this.realBlocks = map;
            }
            return this.realBlocks;
        }

        private Map<BlockPos, BlockState> computeRelativeBlocks() {
            BlockPos median = BlockPos.containing((double)((this.shape.min(Direction.Axis.X) + this.shape.max(Direction.Axis.X)) / 2.0), (double)((this.shape.min(Direction.Axis.Y) + this.shape.max(Direction.Axis.Y)) / 2.0), (double)((this.shape.min(Direction.Axis.Z) + this.shape.max(Direction.Axis.Z)) / 2.0));
            HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
            for (Map.Entry<BlockPos, BlockState> entry : this.blocks.entrySet()) {
                map.put(entry.getKey().subtract((Vec3i)median), entry.getValue());
            }
            return map;
        }
    }
}

