/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import net.swedz.extended_industrialization.EIAttachments;
import net.swedz.extended_industrialization.EIBlocks;
import net.swedz.extended_industrialization.EIConfig;
import net.swedz.extended_industrialization.EIDataMaps;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EILocalizedListeners;
import net.swedz.extended_industrialization.EIOtherRegistries;
import net.swedz.extended_industrialization.datagen.DatagenDelegator;
import net.swedz.extended_industrialization.machines.components.craft.potion.PotionRecipe;
import net.swedz.tesseract.neoforge.api.MCIdentifiable;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.registry.RegisteredObjectHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="extended_industrialization")
public final class EI {
    public static final String ID = "extended_industrialization";
    public static final String NAME = "Extended Industrialization";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Extended Industrialization");

    public static ResourceLocation id(String name) {
        return new ResourceLocation(ID, name);
    }

    public static Set<MCIdentifiable> getAllIdentifiables() {
        HashSet identifiables = Sets.newHashSet();
        identifiables.addAll(EIItems.values());
        identifiables.addAll(EIBlocks.values());
        identifiables.addAll(EIFluids.values());
        return identifiables;
    }

    public EI(IEventBus bus) {
        this.loadConfig();
        EILocalizedListeners.INSTANCE.init();
        EIItems.init(bus);
        EIBlocks.init(bus);
        EIFluids.init(bus);
        EIAttachments.init(bus);
        EIOtherRegistries.init(bus);
        bus.register((Object)new DatagenDelegator());
        bus.addListener(FMLCommonSetupEvent.class, event -> {
            EIItems.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
            EIBlocks.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
            EIFluids.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
            PotionRecipe.init();
        });
        bus.addListener(RegisterCapabilitiesEvent.class, event -> CapabilitiesListeners.triggerAll((String)ID, (RegisterCapabilitiesEvent)event));
        bus.addListener(RegisterDataMapTypesEvent.class, EIDataMaps::init);
    }

    private void loadConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EIConfig.SPEC);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("extended_industrialization-common.toml")).preserveInsertionOrder().autoreload().writingMode(WritingMode.REPLACE).sync().build();
        configData.load();
        EIConfig.SPEC.setConfig((CommentedConfig)configData);
        EIConfig.loadConfig();
        LOGGER.info("Forcefully early-loaded config");
    }
}

