/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineBlockEntityRenderer;
import aztech.modern_industrialization.machines.blockentities.multiblocks.LargeTankMultiblockBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBER;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockTankBER;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.swedz.extended_industrialization.EIBlocks;
import net.swedz.extended_industrialization.items.MachineConfigCardItem;
import net.swedz.extended_industrialization.items.SteamChainsawItem;
import net.swedz.extended_industrialization.items.tooltip.MachineConfigCardTooltipComponent;
import net.swedz.extended_industrialization.items.tooltip.SteamChainsawTooltipComponent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="extended_industrialization", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class EIClient {
    @SubscribeEvent
    private static void init(FMLConstructModEvent __) {
        IEventBus bus = ModLoadingContext.get().getActiveContainer().getEventBus();
    }

    @SubscribeEvent
    private static void registerBlockEntityRenderers(FMLClientSetupEvent event) {
        for (DeferredHolder blockDef : EIBlocks.Registry.BLOCKS.getEntries()) {
            Object object = blockDef.get();
            if (!(object instanceof MachineBlock)) continue;
            MachineBlock machine = (MachineBlock)object;
            MachineBlockEntity blockEntity = machine.getBlockEntityInstance();
            BlockEntityType type = blockEntity.getType();
            if (blockEntity instanceof LargeTankMultiblockBlockEntity) {
                BlockEntityRenderers.register((BlockEntityType)type, MultiblockTankBER::new);
                continue;
            }
            if (blockEntity instanceof MultiblockMachineBlockEntity) {
                BlockEntityRenderers.register((BlockEntityType)type, MultiblockMachineBER::new);
                continue;
            }
            BlockEntityRenderers.register((BlockEntityType)type, c -> new MachineBlockEntityRenderer(c));
        }
    }

    @SubscribeEvent
    private static void registerClientTooltipComponents(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(SteamChainsawItem.SteamChainsawTooltipData.class, SteamChainsawTooltipComponent::new);
        event.register(MachineConfigCardItem.TooltipData.class, MachineConfigCardTooltipComponent::new);
    }
}

