/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.EnergyApi;
import com.google.common.collect.Lists;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.items.PhotovoltaicCellItem;
import net.swedz.extended_industrialization.machines.blockentities.multiblock.LargeElectricFurnaceBlockEntity;

public final class EITooltips {
    public static final MITooltips.Parser<MutableComponent> MULCH_GANG_FOR_LIFE_PARSER = component -> component.withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    public static final MITooltips.Parser<Float> RATIO_PERCENTAGE_PARSER = ratio -> Component.literal((String)"%d%%".formatted((int)(ratio.floatValue() * 100.0f))).withStyle(MITooltips.NUMBER_TEXT);
    public static final MITooltips.Parser<Long> TICKS_TO_MINUTES_PARSER = ticks -> {
        float minutes = (float)ticks.longValue() / 1200.0f;
        return Component.literal((String)"%.2f".formatted(Float.valueOf(minutes))).withStyle(MITooltips.NUMBER_TEXT);
    };
    public static final MITooltips.TooltipAttachment ENERGY_STORED_ITEM = MITooltips.TooltipAttachment.of((itemStack, item) -> {
        long capacity;
        ILongEnergyStorage energyStorage;
        if (BuiltInRegistries.ITEM.getKey(item).getNamespace().equals("extended_industrialization") && (energyStorage = (ILongEnergyStorage)itemStack.getCapability(EnergyApi.ITEM)) != null && (capacity = energyStorage.getCapacity()) > 0L) {
            return Optional.of(new MITooltips.Line(MIText.EnergyStored).arg((Object)new MITooltips.NumberWithMax((Number)energyStorage.getAmount(), (Number)capacity), MITooltips.EU_MAXED_PARSER).build());
        }
        return Optional.empty();
    }).noShiftRequired();
    public static final MITooltips.TooltipAttachment MULCH_GANG_FOR_LIFE = MITooltips.TooltipAttachment.ofMultilines(EIItems.MULCH, List.of(MULCH_GANG_FOR_LIFE_PARSER.parse((Object)EIText.MULCH_GANG_FOR_LIFE_0.text()), MULCH_GANG_FOR_LIFE_PARSER.parse((Object)EIText.MULCH_GANG_FOR_LIFE_1.text()))).noShiftRequired();
    public static final MITooltips.TooltipAttachment COILS = MITooltips.TooltipAttachment.of((itemStack, item) -> {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (LargeElectricFurnaceBlockEntity.getTiersByCoil().containsKey(BuiltInRegistries.BLOCK.getKey((Object)blockItem.getBlock()))) {
                LargeElectricFurnaceBlockEntity.Tier tier = LargeElectricFurnaceBlockEntity.getTiersByCoil().get(BuiltInRegistries.BLOCK.getKey((Object)((BlockItem)itemStack.getItem()).getBlock()));
                int batchSize = tier.batchSize();
                float euCostMultiplier = tier.euCostMultiplier();
                return Optional.of(MITooltips.DEFAULT_PARSER.parse((Object)EIText.COILS_LEF_TIER.text(MITooltips.DEFAULT_PARSER.parse((Object)batchSize), RATIO_PERCENTAGE_PARSER.parse((Object)Float.valueOf(euCostMultiplier)))));
            }
        }
        return Optional.empty();
    });
    public static final MITooltips.TooltipAttachment PHOTOVOLTAIC_CELLS = MITooltips.TooltipAttachment.ofMultilines((itemStack, item) -> {
        if (item instanceof PhotovoltaicCellItem) {
            PhotovoltaicCellItem photovoltaicCell = (PhotovoltaicCellItem)((Object)item);
            int euPerTick = photovoltaicCell.getEuPerTick();
            ArrayList lines = Lists.newArrayList();
            lines.add(MITooltips.DEFAULT_PARSER.parse((Object)EIText.PHOTOVOLTAIC_CELL_EU.text(MITooltips.EU_PER_TICK_PARSER.parse((Object)euPerTick))));
            if (!photovoltaicCell.lastsForever()) {
                int solarTicksRemaining = photovoltaicCell.getSolarTicksRemaining((ItemStack)itemStack);
                lines.add(MITooltips.DEFAULT_PARSER.parse((Object)EIText.PHOTOVOLTAIC_CELL_REMAINING_OPERATION_TIME_MINUTES.text(TICKS_TO_MINUTES_PARSER.parse((Object)solarTicksRemaining))));
            } else {
                lines.add(MITooltips.DEFAULT_PARSER.parse((Object)EIText.PHOTOVOLTAIC_CELL_REMAINING_OPERATION_TIME.text(Component.literal((String)"\u221e").withStyle(MITooltips.NUMBER_TEXT))));
            }
            return Optional.of(lines);
        }
        return Optional.empty();
    });
    public static final MITooltips.TooltipAttachment STEAM_CHAINSAW = MITooltips.TooltipAttachment.ofMultilines(EIItems.STEAM_CHAINSAW, List.of(EIText.STEAM_CHAINSAW_1.text(), EIText.STEAM_CHAINSAW_2.text(), EIText.STEAM_CHAINSAW_3.text(), EIText.STEAM_CHAINSAW_4.text()));
    public static final MITooltips.TooltipAttachment MACHINE_CONFIG_CARD = MITooltips.TooltipAttachment.ofMultilines(EIItems.MACHINE_CONFIG_CARD, List.of(EIText.MACHINE_CONFIG_CARD_HELP_1.text(), EIText.MACHINE_CONFIG_CARD_HELP_2.text(), EIText.MACHINE_CONFIG_CARD_HELP_3.text(), EIText.MACHINE_CONFIG_CARD_HELP_4.text(), EIText.MACHINE_CONFIG_CARD_HELP_5.text(), EIText.MACHINE_CONFIG_CARD_HELP_6.text()));

    public static void init() {
    }
}

