/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.client.provider;

import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import java.util.Map;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EIMachines;
import net.swedz.extended_industrialization.EIText;
import net.swedz.tesseract.neoforge.registry.holder.FluidHolder;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class LanguageDatagenProvider
extends LanguageProvider {
    public LanguageDatagenProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), "extended_industrialization", "en_us");
    }

    protected void addTranslations() {
        for (EIText text : EIText.values()) {
            this.add(text.getTranslationKey(), text.englishText());
        }
        for (ItemHolder itemHolder : EIItems.values()) {
            this.add(itemHolder.asItem(), itemHolder.identifier().englishName());
        }
        for (FluidHolder fluidHolder : EIFluids.values()) {
            this.add(fluidHolder.block().get(), fluidHolder.identifier().englishName());
        }
        for (Map.Entry entry : EIMachines.RecipeTypes.getNames().entrySet()) {
            this.add("recipe_type.%s.%s".formatted(((MachineRecipeType)entry.getKey()).getId().getNamespace(), ((MachineRecipeType)entry.getKey()).getPath()), (String)entry.getValue());
        }
        this.add("itemGroup.%s.%s".formatted("extended_industrialization", "extended_industrialization"), "Extended Industrialization");
        this.add("lef_tier.%s.%s.%s".formatted("extended_industrialization", "modern_industrialization", "cupronickel_coil"), "Cupronickel");
        this.add("lef_tier.%s.%s.%s".formatted("extended_industrialization", "modern_industrialization", "kanthal_coil"), "Kanthal");
    }
}

