/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.server;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.datagen.server.provider.datamaps.DataMapDatagenProvider;
import net.swedz.extended_industrialization.datagen.server.provider.loottable.BlockLootTableDatagenProvider;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.AlloySmelterRecipesServerDatagenProvider;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.BendingMachineRecipesServerDatagenProvider;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.CanningMachineRecipesServerDatagenProvider;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.CommonRecipesServerDatagenProvider;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.ComposterRecipesServerDatagenProvider;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.MachineItemRecipesServerDatagenProvider;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.NPKProcessingRecipesServerDatagenProvider;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.VanillaCompatRecipesServerDatagenProvider;
import net.swedz.extended_industrialization.datagen.server.provider.tags.BlockTagDatagenProvider;
import net.swedz.extended_industrialization.datagen.server.provider.tags.ItemTagDatagenProvider;

public final class DatagenDelegatorServer {
    public static void configure(GatherDataEvent event) {
        DatagenDelegatorServer.add(event, DataMapDatagenProvider::new);
        DatagenDelegatorServer.addLootTable(event, BlockLootTableDatagenProvider::new);
        DatagenDelegatorServer.add(event, AlloySmelterRecipesServerDatagenProvider::new);
        DatagenDelegatorServer.add(event, BendingMachineRecipesServerDatagenProvider::new);
        DatagenDelegatorServer.add(event, CanningMachineRecipesServerDatagenProvider::new);
        DatagenDelegatorServer.add(event, CommonRecipesServerDatagenProvider::new);
        DatagenDelegatorServer.add(event, ComposterRecipesServerDatagenProvider::new);
        DatagenDelegatorServer.add(event, MachineItemRecipesServerDatagenProvider::new);
        DatagenDelegatorServer.add(event, NPKProcessingRecipesServerDatagenProvider::new);
        DatagenDelegatorServer.add(event, VanillaCompatRecipesServerDatagenProvider::new);
        DatagenDelegatorServer.add(event, BlockTagDatagenProvider::new);
        DatagenDelegatorServer.add(event, ItemTagDatagenProvider::new);
    }

    private static void add(GatherDataEvent event, Function<GatherDataEvent, DataProvider> providerCreator) {
        event.getGenerator().addProvider(event.includeServer(), providerCreator.apply(event));
    }

    private static void addLootTable(GatherDataEvent event, Supplier<LootTableSubProvider> providerCreator) {
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new LootTableProvider(event.getGenerator().getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(providerCreator, LootContextParamSets.BLOCK))));
    }
}

