/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.server.provider.datamaps;

import aztech.modern_industrialization.MI;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.EIDataMaps;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.datamaps.FarmerSimpleTallCropSize;
import net.swedz.extended_industrialization.datamaps.FertilizerPotency;
import net.swedz.extended_industrialization.datamaps.LargeElectricFurnaceTier;
import net.swedz.extended_industrialization.datamaps.PotionBrewingCosts;
import net.swedz.tesseract.neoforge.registry.holder.FluidHolder;

public final class DataMapDatagenProvider
extends DataMapProvider {
    public DataMapDatagenProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider());
    }

    protected void gather() {
        this.addFarmerSimpleTallCropSize(Blocks.SUGAR_CANE, 3);
        this.addFarmerSimpleTallCropSize(Blocks.CACTUS, 3);
        this.addFluidFertilizerPotency((FluidHolder)EIFluids.MANURE, 25, 100);
        this.addFluidFertilizerPotency((FluidHolder)EIFluids.COMPOSTED_MANURE, 25, 50);
        this.addFluidFertilizerPotency((FluidHolder)EIFluids.NPK_FERTILIZER, 10, 10);
        this.addLargeElectricFurnaceTier(MI.id((String)"cupronickel_coil"), 8, 0.75f);
        this.addLargeElectricFurnaceTier(MI.id((String)"kanthal_coil"), 32, 0.75f);
        for (Map.Entry entry : BuiltInRegistries.POTION.entrySet()) {
            this.addPotionBrewing((ResourceKey<Potion>)((ResourceKey)entry.getKey()), 4, 1000, 1, 200, 4);
        }
    }

    private void addFarmerSimpleTallCropSize(ResourceLocation block, int maxHeight) {
        this.builder(EIDataMaps.FARMER_SIMPLE_TALL_CROP_SIZE).add(block, (Object)new FarmerSimpleTallCropSize(maxHeight), false, new ICondition[0]);
    }

    private void addFarmerSimpleTallCropSize(Block block, int maxHeight) {
        this.addFarmerSimpleTallCropSize(BuiltInRegistries.BLOCK.getKey((Object)block), maxHeight);
    }

    private void addFluidFertilizerPotency(FluidHolder fluid, int tickRate, int mbToConsumePerFertilizerTick) {
        this.builder(EIDataMaps.FERTILIZER_POTENCY).add(fluid.identifier().location(), (Object)new FertilizerPotency(tickRate, mbToConsumePerFertilizerTick), false, new ICondition[0]);
    }

    private void addLargeElectricFurnaceTier(ResourceLocation block, int batchSize, float euCostMultiplier) {
        this.builder(EIDataMaps.LARGE_ELECTRIC_FURNACE_TIER).add(block, (Object)new LargeElectricFurnaceTier(batchSize, euCostMultiplier), false, new ICondition[0]);
    }

    private void addPotionBrewing(ResourceKey<Potion> potion, int bottles, int water, int blazingEssence, int time, int euCost) {
        this.builder(EIDataMaps.POTION_BREWING).add(potion, (Object)new PotionBrewingCosts(bottles, water, blazingEssence, time, euCost), false, new ICondition[0]);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

