/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.server.provider.recipes;

import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EIMachines;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.RecipesServerDatagenProvider;

public final class CanningMachineRecipesServerDatagenProvider
extends RecipesServerDatagenProvider {
    public CanningMachineRecipesServerDatagenProvider(GatherDataEvent event) {
        super(event);
    }

    private static void addFillingAndEmptyingRecipes(FluidStack fluidStack, Item emptyItem, Item fullItem, RecipeOutput output) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)fullItem);
        CanningMachineRecipesServerDatagenProvider.addMachineRecipe("canning_machine/filling/%s".formatted(id.getNamespace()), id.getPath(), EIMachines.RecipeTypes.CANNING_MACHINE, 2, 100, r -> ((MachineRecipeBuilder)((MachineRecipeBuilder)r.addFluidInput(fluidStack.getFluid(), fluidStack.getAmount())).addItemInput((ItemLike)emptyItem, 1)).addItemOutput(fullItem, 1), output);
        CanningMachineRecipesServerDatagenProvider.addMachineRecipe("canning_machine/emptying/%s".formatted(id.getNamespace()), id.getPath(), EIMachines.RecipeTypes.CANNING_MACHINE, 2, 100, r -> ((MachineRecipeBuilder)((MachineRecipeBuilder)r.addItemInput((ItemLike)fullItem, 1)).addItemOutput(emptyItem, 1)).addFluidOutput(fluidStack.getFluid(), fluidStack.getAmount()), output);
    }

    private static void addCannedFoodRecipe(Item foodItem, FoodProperties food, RecipeOutput output) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)foodItem);
        int count = (int)Math.ceil((double)food.getNutrition() / 2.0);
        CanningMachineRecipesServerDatagenProvider.addMachineRecipe("canning_machine/canned_food/%s".formatted(id.getNamespace()), id.getPath(), EIMachines.RecipeTypes.CANNING_MACHINE, 2, 100, r -> ((MachineRecipeBuilder)((MachineRecipeBuilder)r.addItemInput(EIItems.TIN_CAN, count)).addItemInput((ItemLike)foodItem, 1)).addItemOutput(EIItems.CANNED_FOOD, count), output);
    }

    private static void bucketRecipes(RecipeOutput output) {
        HashSet uniqueFluids = Sets.newHashSet();
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            Item fullItem;
            Fluid processedFluid;
            Fluid fluid2;
            if (fluid instanceof FlowingFluid) {
                FlowingFluid flowingFluid = (FlowingFluid)fluid;
                fluid2 = flowingFluid.getSource();
            } else {
                fluid2 = fluid;
            }
            if (!uniqueFluids.add(processedFluid = fluid2) || (fullItem = processedFluid.getBucket()) == Items.AIR) continue;
            CanningMachineRecipesServerDatagenProvider.addFillingAndEmptyingRecipes(new FluidStack(processedFluid, 1000), Items.BUCKET, fullItem, output);
        }
    }

    private static void cannedFoodRecipes(RecipeOutput output) {
        for (Item item : BuiltInRegistries.ITEM) {
            if (!item.isEdible() || item == EIItems.CANNED_FOOD.asItem() || item instanceof BowlFoodItem || item instanceof HoneyBottleItem) continue;
            FoodProperties food = item.getFoodProperties(item.getDefaultInstance(), null);
            CanningMachineRecipesServerDatagenProvider.addCannedFoodRecipe(item, food, output);
        }
    }

    protected void buildRecipes(RecipeOutput output) {
        CanningMachineRecipesServerDatagenProvider.bucketRecipes(output);
        CanningMachineRecipesServerDatagenProvider.addFillingAndEmptyingRecipes(new FluidStack(EIFluids.HONEY.asFluid(), 250), Items.GLASS_BOTTLE, Items.HONEY_BOTTLE, output);
        CanningMachineRecipesServerDatagenProvider.cannedFoodRecipes(output);
    }
}

