/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.server.provider.recipes;

import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EIMachines;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.RecipesServerDatagenProvider;

public final class ComposterRecipesServerDatagenProvider
extends RecipesServerDatagenProvider {
    public ComposterRecipesServerDatagenProvider(GatherDataEvent event) {
        super(event);
    }

    private static void addStandardCompostingRecipes(RecipeOutput output) {
        for (Item item : BuiltInRegistries.ITEM) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            float chance = ComposterBlock.getValue((ItemStack)item.getDefaultInstance());
            if (!(chance > 0.0f)) continue;
            int amountNeeded = Math.max(1, (int)Math.floor(8.0f / chance / 2.0f));
            ComposterRecipesServerDatagenProvider.addMachineRecipe("composter/standard/%s".formatted(id.getNamespace()), id.getPath(), EIMachines.RecipeTypes.COMPOSTER, 2, 100, r -> ((MachineRecipeBuilder)r.addItemInput((ItemLike)item, amountNeeded)).addItemOutput(Items.BONE_MEAL, 1), output);
        }
    }

    protected void buildRecipes(RecipeOutput output) {
        ComposterRecipesServerDatagenProvider.addStandardCompostingRecipes(output);
        ComposterRecipesServerDatagenProvider.addMachineRecipe("composter/fertilizer", "composted_manure", EIMachines.RecipeTypes.COMPOSTER, 4, 100, r -> ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)r.addFluidInput((FluidLike)EIFluids.MANURE, 150)).addItemInput((ItemLike)Items.BONE_MEAL, 1)).addItemInput(EIItems.MULCH, 1)).addFluidOutput((FluidLike)EIFluids.COMPOSTED_MANURE, 200), output);
    }
}

