/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.items;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.items.DynamicToolItem;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.technici4n.grandpower.api.ISimpleEnergyItem;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.TierSortingRegistry;

public class ElectricToolItem
extends Item
implements Vanishable,
DynamicToolItem,
ISimpleEnergyItem {
    private static final long ENERGY_COST = 2048L;
    private final Type type;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ElectricToolItem(Item.Properties properties, Type type) {
        super(properties.stacksTo(1).rarity(Rarity.UNCOMMON));
        this.type = type;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Tool modifier", (double)type.damage(), AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.category.canEnchant(stack.getItem()) || enchantment.category == EnchantmentCategory.DIGGER && enchantment != Enchantments.SILK_TOUCH && enchantment != Enchantments.BLOCK_FORTUNE || stack.is(ItemTags.AXES) && enchantment.category == EnchantmentCategory.WEAPON && enchantment != Enchantments.SWEEPING_EDGE;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miner) {
        if (state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            this.tryUseEnergy(stack, 2048L);
        }
        return true;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.tryUseEnergy(stack, 2048L);
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if ((this.type.worksForAllBlocks() || this.isSupportedBlock(stack, state)) && this.getStoredEnergy(stack) > 0L && TierSortingRegistry.isCorrectTierForDrops((Tier)Tiers.NETHERITE, (BlockState)state)) {
            return true;
        }
        return super.isCorrectToolForDrops(stack, state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if ((this.type.worksForAllBlocks() || this.isSupportedBlock(stack, state)) && this.getStoredEnergy(stack) > 0L) {
            return Tiers.NETHERITE.getSpeed();
        }
        return 1.0f;
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.getDefaultAttributeModifiers(slot);
    }

    public boolean isBarVisible(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        return tag == null || !tag.getBoolean("hide_bar");
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.round((double)this.getStoredEnergy(stack) / (double)this.type.energyCapacity() * 13.0);
    }

    public int getBarColor(ItemStack stack) {
        float hue = Math.max(0.0f, (float)this.getStoredEnergy(stack) / (float)this.type.energyCapacity());
        return Mth.hsvToRgb((float)(hue / 3.0f), (float)1.0f, (float)1.0f);
    }

    public long getEnergyCapacity(ItemStack stack) {
        return this.type.energyCapacity();
    }

    public long getEnergyMaxInput(ItemStack stack) {
        return this.type.energyCapacity();
    }

    public long getEnergyMaxOutput(ItemStack stack) {
        return this.type.energyCapacity();
    }

    private static boolean isFortune(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        return tag != null && tag.getBoolean("fortune");
    }

    private static void setFortune(ItemStack stack, boolean fortune) {
        if (fortune) {
            stack.getOrCreateTag().putBoolean("fortune", true);
        } else {
            stack.removeTagKey("fortune");
        }
    }

    public void appendHoverText(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        if (this.getStoredEnergy(stack) > 0L) {
            Enchantment enchantment = ElectricToolItem.isFortune(stack) ? Enchantments.BLOCK_FORTUNE : Enchantments.SILK_TOUCH;
            tooltip.add(enchantment.getFullname(enchantment.getMaxLevel()));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && user.isShiftKeyDown()) {
            ItemStack stack;
            ElectricToolItem.setFortune(stack, !ElectricToolItem.isFortune(stack = user.getItemInHand(hand)));
            if (!world.isClientSide) {
                user.displayClientMessage((Component)(ElectricToolItem.isFortune(stack) ? MIText.ToolSwitchedFortune.text() : MIText.ToolSwitchedSilkTouch.text()), true);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
        }
        return super.use(world, user, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (this.getStoredEnergy(stack) > 0L) {
            BlockState newState;
            Block newBlock;
            if (stack.is(ItemTags.AXES) && (newBlock = StrippingAccess.getStrippedBlocks().get(state.getBlock())) != null) {
                level.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.isClientSide) {
                    level.setBlock(pos, (BlockState)newBlock.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS))), 11);
                    this.tryUseEnergy(stack, 2048L);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.is(ItemTags.SHOVELS) && (newState = PathingAccess.getPathStates().get(state.getBlock())) != null) {
                level.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.isClientSide) {
                    level.setBlock(pos, newState, 11);
                    this.tryUseEnergy(stack, 2048L);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useOn(context);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        Level level = interactionTarget.level();
        BlockPos blockPos = interactionTarget.blockPosition();
        if (this.getStoredEnergy(stack) > 0L && stack.is(Tags.Items.SHEARS) && interactionTarget instanceof IShearable) {
            IShearable shearable = (IShearable)interactionTarget;
            if (!level.isClientSide && shearable.isShearable(stack, level, blockPos)) {
                this.tryUseEnergy(stack, 2048L);
                shearable.onSheared(player, stack, level, blockPos, ElectricToolItem.isFortune(stack) ? Enchantments.BLOCK_FORTUNE.getMaxLevel() : 0).forEach(drop -> shearable.spawnShearedDrop(level, blockPos, drop));
                interactionTarget.gameEvent(GameEvent.SHEAR, (Entity)player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return this.getAllEnchantments(stack).getOrDefault(enchantment, 0);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map map = EnchantmentHelper.deserializeEnchantments((ListTag)stack.getEnchantmentTags());
        if (this.getStoredEnergy(stack) > 0L) {
            if (!ElectricToolItem.isFortune(stack)) {
                map.put(Enchantments.SILK_TOUCH, Enchantments.SILK_TOUCH.getMaxLevel());
            } else {
                map.put(Enchantments.BLOCK_FORTUNE, Enchantments.BLOCK_FORTUNE.getMaxLevel());
            }
        }
        return map;
    }

    public boolean isFoil(ItemStack stack) {
        return this.getAllEnchantments(stack).size() > (this.getStoredEnergy(stack) > 0L ? 1 : 0);
    }

    public static enum Type {
        DRILL(1200L * CableTier.HV.getMaxTransfer(), 9.0f, 9, false),
        CHAINSAW(1200L * CableTier.HV.getMaxTransfer(), 9.0f, 15, false),
        ULTIMATE(1200L * CableTier.EV.getMaxTransfer(), 12.0f, 19, true);

        private final long energyCapacity;
        private final float speed;
        private final int damage;
        private final boolean worksForAllBlocks;

        private Type(long energyCapacity, float speed, int damage, boolean worksForAllBlocks) {
            this.energyCapacity = energyCapacity;
            this.speed = speed;
            this.damage = damage;
            this.worksForAllBlocks = worksForAllBlocks;
        }

        public long energyCapacity() {
            return this.energyCapacity;
        }

        public int damage() {
            return this.damage;
        }

        public boolean worksForAllBlocks() {
            return this.worksForAllBlocks;
        }
    }

    private static class StrippingAccess
    extends AxeItem {
        private StrippingAccess(Tier material, float attackDamage, float attackSpeed, Item.Properties settings) {
            super(material, attackDamage, attackSpeed, settings);
        }

        public static Map<Block, Block> getStrippedBlocks() {
            return AxeItem.STRIPPABLES;
        }
    }

    private static class PathingAccess
    extends ShovelItem {
        private PathingAccess(Tier material, float attackDamage, float attackSpeed, Item.Properties settings) {
            super(material, attackDamage, attackSpeed, settings);
        }

        public static Map<Block, BlockState> getPathStates() {
            return ShovelItem.FLATTENABLES;
        }
    }
}

