/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.items;

import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.mixin.mi.accessor.ConfigurableItemStackAccessor;

public final class MachineConfigCardItem
extends Item {
    private static final String TAG = "machine_config";

    public MachineConfigCardItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null) {
            InteractionHand usedHand = context.getHand();
            ItemStack itemStack = player.getItemInHand(usedHand);
            BlockEntity hitBlockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
            if (hitBlockEntity instanceof MachineBlockEntity) {
                MachineBlockEntity machine = (MachineBlockEntity)hitBlockEntity;
                if (!(hitBlockEntity instanceof MultiblockMachineBlockEntity)) {
                    if (!context.getLevel().isClientSide()) {
                        if (player.isShiftKeyDown()) {
                            MachineConfig config = MachineConfigCardItem.readFromMachine(machine);
                            itemStack.getOrCreateTag().put(TAG, (Tag)config.serialize());
                            player.displayClientMessage((Component)EIText.MACHINE_CONFIG_CARD_SAVE.text(), true);
                        } else {
                            CompoundTag machineConfigTag = itemStack.getTagElement(TAG);
                            if (machineConfigTag != null) {
                                MachineConfig config = MachineConfigCardItem.readFromNBT(machineConfigTag);
                                if (MachineConfigCardItem.writeToMachine(machine, config, Simulation.SIMULATE)) {
                                    MachineConfigCardItem.writeToMachine(machine, config, Simulation.ACT);
                                    player.displayClientMessage((Component)EIText.MACHINE_CONFIG_CARD_APPLY_SUCCESS.text(), true);
                                } else {
                                    player.displayClientMessage((Component)EIText.MACHINE_CONFIG_CARD_APPLY_FAILED.text(), true);
                                }
                            }
                        }
                    }
                    return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
                }
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player.isShiftKeyDown()) {
            player.getItemInHand(usedHand).removeTagKey(TAG);
            player.displayClientMessage((Component)EIText.MACHINE_CONFIG_CARD_CLEAR.text(), true);
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(usedHand), (boolean)level.isClientSide());
        }
        return super.use(level, player, usedHand);
    }

    public void appendHoverText(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag configTag = stack.getTagElement(TAG);
        if (configTag != null) {
            Block machineBlock = (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(configTag.getString("machine_block")));
            tooltipComponents.add((Component)EIText.MACHINE_CONFIG_CARD_CONFIGURED.text(MITooltips.ITEM_PARSER.parse((Object)machineBlock.asItem())));
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        CompoundTag configTag = stack.getTagElement(TAG);
        if (configTag != null) {
            Block machineBlock = (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(configTag.getString("machine_block")));
            Item item = machineBlock.asItem();
            return Optional.of(new TooltipData(item.getDefaultInstance()));
        }
        return Optional.empty();
    }

    private static MachineConfig readFromMachine(MachineBlockEntity machine) {
        Block block = machine.getBlockState().getBlock();
        MIInventory inventory = machine.getInventory();
        ArrayList slots = Lists.newArrayList();
        int itemIndex = 0;
        for (ConfigurableItemStack itemStack : inventory.getItemStacks()) {
            slots.add(new MachineConfig.ItemSlot(itemIndex, itemStack.getAdjustedCapacity(), (Item)itemStack.getLockedInstance()));
            ++itemIndex;
        }
        int fluidIndex = 0;
        for (ConfigurableFluidStack fluidStack : inventory.getFluidStacks()) {
            slots.add(new MachineConfig.FluidSlot(fluidIndex, (Fluid)fluidStack.getLockedInstance()));
            ++fluidIndex;
        }
        return new MachineConfig(block, slots, itemIndex, fluidIndex);
    }

    private static MachineConfig readFromNBT(CompoundTag tag) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(tag.getString("machine_block")));
        ArrayList slots = Lists.newArrayList();
        int itemSlotCount = 0;
        int fluidSlotCount = 0;
        ListTag slotsTag = tag.getList("slots", 10);
        for (Tag slotTagTag : slotsTag) {
            CompoundTag slotTag = (CompoundTag)slotTagTag;
            int index = slotTag.getInt("index");
            String typeId = slotTag.getString("type");
            if (typeId.equals("item")) {
                int capacity = slotTag.getInt("capacity");
                Item lock = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(slotTag.getString("lock")));
                slots.add(new MachineConfig.ItemSlot(index, capacity, lock));
                ++itemSlotCount;
                continue;
            }
            if (typeId.equals("fluid")) {
                Fluid lock = (Fluid)BuiltInRegistries.FLUID.get(new ResourceLocation(slotTag.getString("lock")));
                slots.add(new MachineConfig.FluidSlot(index, lock));
                ++fluidSlotCount;
                continue;
            }
            throw new IllegalArgumentException("Malformed machine config nbt: %s".formatted(tag.toString()));
        }
        return new MachineConfig(block, slots, itemSlotCount, fluidSlotCount);
    }

    private static boolean writeToMachine(MachineBlockEntity machine, MachineConfig config, Simulation simulation) {
        if (!config.matches(machine)) {
            return false;
        }
        boolean success = true;
        for (MachineConfig.Slot slot : config.slots()) {
            Object stack = slot.stack(machine.getInventory());
            if (slot.lock() != null && stack.canPlayerLock() && !stack.playerLock(slot.lock(), simulation)) {
                success = false;
            }
            if (slot.capacity() < 0 || !(slot instanceof MachineConfig.ItemSlot)) continue;
            ConfigurableItemStack itemStack = (ConfigurableItemStack)stack;
            if (itemStack.getAmount() <= (long)slot.capacity()) {
                if (simulation != Simulation.ACT) continue;
                ConfigurableItemStackAccessor capacityAccessor = (ConfigurableItemStackAccessor)stack;
                capacityAccessor.setAdjustedCapacity(slot.capacity());
                continue;
            }
            success = false;
        }
        return success;
    }

    private record MachineConfig(Block machineBlock, List<Slot> slots, int itemSlotCount, int fluidSlotCount) {
        public boolean matches(MachineBlockEntity machine) {
            return machine.getBlockState().getBlock() == this.machineBlock && machine.getInventory().getItemStacks().size() == this.itemSlotCount && machine.getInventory().getFluidStacks().size() == this.fluidSlotCount;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.putString("machine_block", BuiltInRegistries.BLOCK.getKey((Object)this.machineBlock).toString());
            ListTag slotsTag = new ListTag();
            for (Slot slot : this.slots) {
                slotsTag.add((Object)slot.serialize());
            }
            tag.put("slots", (Tag)slotsTag);
            return tag;
        }

        static interface Slot<T, S extends AbstractConfigurableStack> {
            public int index();

            public int capacity();

            public T lock();

            public S stack(MIInventory var1);

            public CompoundTag serialize();
        }

        private static final class FluidSlot
        extends Record
        implements Slot<Fluid, ConfigurableFluidStack> {
            private final int index;
            private final Fluid lock;

            private FluidSlot(int index, Fluid lock) {
                this.index = index;
                this.lock = lock;
            }

            @Override
            public int capacity() {
                return -1;
            }

            @Override
            public ConfigurableFluidStack stack(MIInventory inventory) {
                return (ConfigurableFluidStack)inventory.getFluidStacks().get(this.index);
            }

            @Override
            public CompoundTag serialize() {
                CompoundTag tag = new CompoundTag();
                tag.putInt("index", this.index);
                tag.putString("type", "fluid");
                tag.putString("lock", BuiltInRegistries.FLUID.getKey((Object)this.lock).toString());
                return tag;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{FluidSlot.class, "index;lock", "index", "lock"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FluidSlot.class, "index;lock", "index", "lock"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FluidSlot.class, "index;lock", "index", "lock"}, this, o);
            }

            @Override
            public int index() {
                return this.index;
            }

            @Override
            public Fluid lock() {
                return this.lock;
            }
        }

        private static final class ItemSlot
        extends Record
        implements Slot<Item, ConfigurableItemStack> {
            private final int index;
            private final int capacity;
            private final Item lock;

            private ItemSlot(int index, int capacity, Item lock) {
                this.index = index;
                this.capacity = capacity;
                this.lock = lock;
            }

            @Override
            public ConfigurableItemStack stack(MIInventory inventory) {
                return (ConfigurableItemStack)inventory.getItemStacks().get(this.index);
            }

            @Override
            public CompoundTag serialize() {
                CompoundTag tag = new CompoundTag();
                tag.putInt("index", this.index);
                tag.putString("type", "item");
                tag.putString("lock", BuiltInRegistries.ITEM.getKey((Object)this.lock).toString());
                tag.putInt("capacity", this.capacity);
                return tag;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemSlot.class, "index;capacity;lock", "index", "capacity", "lock"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemSlot.class, "index;capacity;lock", "index", "capacity", "lock"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemSlot.class, "index;capacity;lock", "index", "capacity", "lock"}, this, o);
            }

            @Override
            public int index() {
                return this.index;
            }

            @Override
            public int capacity() {
                return this.capacity;
            }

            @Override
            public Item lock() {
                return this.lock;
            }
        }
    }

    public record TooltipData(ItemStack machineItemStack) implements TooltipComponent
    {
    }
}

