/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentities;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.machines.components.MachineChainerComponent;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock.ModularMultiblockGui;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock.ModularMultiblockGuiLine;

public final class MachineChainerMachineBlockEntity
extends MachineBlockEntity
implements Tickable {
    private final MachineChainerComponent chainer = new MachineChainerComponent(this, 64);
    private int tick;
    private boolean needsRebuild;

    public MachineChainerMachineBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder("machine_chainer", false).backgroundHeight(180).build(), new OrientationComponent.Params(false, false, false));
        this.registerComponents(new IComponent[]{this.chainer});
        this.registerGuiComponent(new GuiComponent.Server[]{new ModularMultiblockGui.Server(60, () -> {
            ArrayList text = Lists.newArrayList();
            text.add(new ModularMultiblockGuiLine((Component)EIText.MACHINE_CHAINER_CONNECTED_MACHINES.text(this.chainer.getConnectedMachineCount(), this.chainer.getMaxConnectedMachinesCount())));
            return text;
        })});
    }

    public MachineChainerComponent getChainerComponent() {
        return this.chainer;
    }

    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        this.orientation.writeModelData(data);
        return data;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (!level.isClientSide()) {
            this.needsRebuild = true;
        }
    }

    public void onPlaced(LivingEntity placer, ItemStack itemStack) {
        super.onPlaced(placer, itemStack);
        if (!this.level.isClientSide()) {
            this.needsRebuild = false;
            this.chainer.buildLinks();
            this.chainer.registerListeners();
        }
    }

    public void setChanged() {
        super.setChanged();
        if (!this.level.isClientSide()) {
            this.needsRebuild = false;
            this.chainer.unregisterListeners();
            this.chainer.buildLinks();
            this.chainer.registerListeners();
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide()) {
            this.needsRebuild = false;
            this.chainer.unregisterListeners();
            this.chainer.clearLinks();
        }
    }

    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        if (++this.tick == 100) {
            this.tick = 0;
            this.needsRebuild = true;
            this.chainer.unregisterListeners();
        }
        if (this.needsRebuild) {
            this.needsRebuild = false;
            this.chainer.buildLinks();
            this.chainer.registerListeners();
        }
    }

    public static void registerCapabilities(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, bet, (be, direction) -> ((MachineChainerMachineBlockEntity)be).chainer.itemHandler);
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, bet, (be, direction) -> ((MachineChainerMachineBlockEntity)be).chainer.fluidHandler);
            event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> ((MachineChainerMachineBlockEntity)be).chainer.energyHandler);
        });
    }
}

