/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentities;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.machines.components.solar.SolarSunlightComponent;
import net.swedz.extended_industrialization.machines.components.solar.electric.SolarGeneratorComponent;
import net.swedz.extended_industrialization.machines.guicomponents.solarefficiency.SolarEfficiencyBar;

public final class SolarPanelMachineBlockEntity
extends MachineBlockEntity
implements Tickable,
EnergyComponentHolder {
    private static final int CELL_X = 58;
    private static final int CELL_Y = 40;
    private static final int WATER_X = 38;
    private static final int WATER_Y = 40;
    private static final int ENERGY_X = 126;
    private static final int ENERGY_Y = 39;
    private static final int SOLAR_EFFICIENCY_X = 38;
    private static final int SOLAR_EFFICIENCY_Y = 75;
    private final CableTier tier;
    private final RedstoneControlComponent redstoneControl;
    private final MIInventory inventory;
    private final EnergyComponent energy;
    private final MIEnergyStorage extractable;
    private final SolarSunlightComponent sunlight;
    private final SolarGeneratorComponent generator;

    public SolarPanelMachineBlockEntity(BEP bep, String blockName, CableTier tier) {
        super(bep, new MachineGuiParameters.Builder(blockName, true).backgroundHeight(180).build(), new OrientationComponent.Params(false, false, false));
        this.tier = tier;
        long capacity = 32000L;
        this.redstoneControl = new RedstoneControlComponent();
        List<ConfigurableItemStack> itemStacks = List.of(ConfigurableItemStack.standardInputSlot());
        SlotPositions itemPositions = new SlotPositions.Builder().addSlot(58, 40).build();
        List<ConfigurableFluidStack> fluidStacks = List.of(ConfigurableFluidStack.lockedInputSlot((long)capacity, (Fluid)EIFluids.DISTILLED_WATER.asFluid()));
        SlotPositions fluidPositions = new SlotPositions.Builder().addSlot(38, 40).build();
        this.inventory = new MIInventory(itemStacks, fluidStacks, itemPositions, fluidPositions);
        this.energy = new EnergyComponent((BlockEntity)this, () -> tier.getEu() * 100L);
        this.extractable = this.energy.buildExtractable(otherTier -> otherTier == tier);
        this.sunlight = new SolarSunlightComponent(this);
        this.generator = new SolarGeneratorComponent(this.inventory, this.energy, this::getEfficiency, cell -> cell.getTier() == tier);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new EnergyBar.Server(new EnergyBar.Parameters(126, 39), () -> ((EnergyComponent)this.energy).getEu(), () -> ((EnergyComponent)this.energy).getCapacity());
        this.registerGuiComponent(serverArray);
        this.registerGuiComponent(new GuiComponent.Server[]{new SlotPanel.Server((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl)});
        GuiComponent.Server[] serverArray2 = new GuiComponent.Server[1];
        serverArray2[0] = SolarEfficiencyBar.Server.energyProduced(new SolarEfficiencyBar.Parameters(38, 75), this.sunlight::canOperate, () -> (int)(this.getEfficiency() * 100.0f), this.generator::getEnergyPerTick);
        this.registerGuiComponent(serverArray2);
        this.registerComponents(new IComponent[]{this.inventory, this.energy, this.redstoneControl, this.sunlight, this.generator});
    }

    public float getEfficiency() {
        return this.sunlight.getSolarEfficiency();
    }

    public MIInventory getInventory() {
        return this.inventory;
    }

    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(this.tier.casing);
        this.orientation.writeModelData(data);
        return data;
    }

    public EnergyAccess getEnergyComponent() {
        return this.energy;
    }

    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        if (this.sunlight.canOperate() && this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this)) {
            this.generator.tick();
        }
    }

    protected InteractionResult onUse(Player player, InteractionHand hand, Direction face) {
        InteractionResult result = super.onUse(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }

    public List<Component> getTooltips() {
        ArrayList tooltips = Lists.newArrayList();
        tooltips.add(MITooltips.DEFAULT_PARSER.parse((Object)EIText.SOLAR_PANEL_PHOTOVOLTAIC_CELL.text()));
        tooltips.add(MITooltips.DEFAULT_PARSER.parse((Object)EIText.SOLAR_PANEL_SUNLIGHT.text()));
        tooltips.add(MITooltips.DEFAULT_PARSER.parse((Object)EIText.SOLAR_PANEL_DISTILLED_WATER.text(MITooltips.FLUID_PARSER.parse((Object)EIFluids.DISTILLED_WATER.asFluid()))));
        return tooltips;
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> direction != Direction.UP ? ((SolarPanelMachineBlockEntity)be).extractable : null));
    }
}

