/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentities.brewery;

import aztech.modern_industrialization.api.machine.component.CrafterAccess;
import aztech.modern_industrialization.api.machine.holder.CrafterComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.swedz.extended_industrialization.machines.components.craft.potion.PotionCrafterComponent;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.ModularCrafterAccessBehavior;

public abstract class BreweryMachineBlockEntity
extends MachineBlockEntity
implements Tickable,
CrafterComponentHolder,
ModularCrafterAccessBehavior {
    protected static final int STEAM_SLOT_X = 143;
    protected static final int STEAM_SLOT_Y = 27;
    protected static final int BLAZING_ESSENCE_SLOT_X = 8;
    protected static final int BLAZING_ESSENCE_SLOT_Y = 27;
    protected static final int WATER_SLOT_X = 26;
    protected static final int WATER_SLOT_Y = 27;
    protected static final int INPUT_BOTTLE_SLOTS_X = 8;
    protected static final int INPUT_BOTTLE_SLOTS_Y = 47;
    protected static final int INPUT_REAGENT_SLOTS_X = 53;
    protected static final int INPUT_REAGENT_SLOTS_Y = 27;
    protected static final int OUTPUT_SLOTS_X = 116;
    protected static final int OUTPUT_SLOTS_Y = 47;
    protected static final int PROGRESS_BAR_X = 78;
    protected static final int PROGRESS_BAR_Y = 63;
    protected final MachineTier tier;
    protected final int capacity;
    protected final MachineInventoryComponent inventory;
    protected final PotionCrafterComponent crafter;
    protected IsActiveComponent isActiveComponent;

    public BreweryMachineBlockEntity(BEP bep, String blockName, MachineTier tier, int capacity) {
        super(bep, new MachineGuiParameters.Builder(blockName, true).backgroundHeight(206).build(), new OrientationComponent.Params(true, true, false));
        this.tier = tier;
        this.capacity = capacity;
        Pair<MachineInventoryComponent, PotionCrafterComponent.Params> builtInventory = this.buildInventory();
        this.inventory = (MachineInventoryComponent)builtInventory.getFirst();
        this.crafter = new PotionCrafterComponent((PotionCrafterComponent.Params)builtInventory.getSecond(), this, (CrafterComponent.Inventory)this.inventory, this);
        this.isActiveComponent = new IsActiveComponent();
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new ProgressBar.Server(new ProgressBar.Parameters(78, 63, "triple_arrow"), () -> ((PotionCrafterComponent)this.crafter).getProgress());
        this.registerGuiComponent(serverArray);
        this.registerComponents(new IComponent[]{this.isActiveComponent, this.inventory, this.crafter});
        this.registerGuiComponent(new GuiComponent.Server[]{new AutoExtract.Server(this.orientation)});
    }

    protected abstract Pair<MachineInventoryComponent, PotionCrafterComponent.Params> buildInventory();

    public MIInventory getInventory() {
        return this.inventory.inventory;
    }

    public CrafterAccess getCrafterComponent() {
        return this.crafter;
    }

    public Level getCrafterWorld() {
        return this.level;
    }

    public UUID getOwnerUuid() {
        return this.placedBy.placerId;
    }

    public long getBaseRecipeEu() {
        return this.tier.getBaseEu();
    }

    public long getBaseMaxRecipeEu() {
        return this.tier.getMaxEu();
    }

    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        this.updateActive(this.crafter.tickRecipe());
        if (this.orientation.extractItems) {
            this.getInventory().autoExtractItems(this.level, this.worldPosition, this.orientation.outputDirection);
        }
        this.setChanged();
    }

    private void updateActive(boolean active) {
        this.isActiveComponent.updateActive(active, (MachineBlockEntity)this);
    }

    public List<Component> getTooltips() {
        return Collections.emptyList();
    }
}

