/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentities.brewery;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.swedz.extended_industrialization.machines.blockentities.brewery.BreweryMachineBlockEntity;
import net.swedz.extended_industrialization.machines.blockentities.brewery.PotionConfigurableItemStack;
import net.swedz.extended_industrialization.machines.components.craft.potion.PotionCrafterComponent;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.ModularCrafterAccess;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.recipeefficiency.ModularRecipeEfficiencyBar;
import net.swedz.tesseract.neoforge.compat.mi.helper.ModularLubricantHelper;

public final class ElectricBreweryMachineBlockEntity
extends BreweryMachineBlockEntity
implements EnergyComponentHolder {
    private static final int EFFICIENCY_BAR_X = 38;
    private static final int EFFICIENCY_BAR_Y = 106;
    private final EnergyComponent energy;
    private final MIEnergyStorage insertable;
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private final CasingComponent casing = new CasingComponent();
    private final UpgradeComponent upgrades = new UpgradeComponent();

    public ElectricBreweryMachineBlockEntity(BEP bep) {
        super(bep, "electric_brewery", MachineTier.LV, 32000);
        this.energy = new EnergyComponent((BlockEntity)this, 3200L);
        this.insertable = this.energy.buildInsertable(arg_0 -> ((CasingComponent)this.casing).canInsertEu(arg_0));
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new EnergyBar.Server(new EnergyBar.Parameters(144, 26), () -> ((EnergyComponent)this.energy).getEu(), () -> ((EnergyComponent)this.energy).getCapacity());
        this.registerGuiComponent(serverArray);
        this.registerGuiComponent(new GuiComponent.Server[]{new ModularRecipeEfficiencyBar.Server(new ModularRecipeEfficiencyBar.Parameters(38, 106), (ModularCrafterAccess)this.crafter)});
        this.registerGuiComponent(new GuiComponent.Server[]{new SlotPanel.Server((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl).withUpgrades(this.upgrades).withCasing(this.casing)});
        this.registerComponents(new IComponent[]{this.energy, this.redstoneControl, this.casing, this.upgrades});
    }

    @Override
    protected Pair<MachineInventoryComponent, PotionCrafterComponent.Params> buildInventory() {
        int i;
        ArrayList itemInputs = Lists.newArrayList();
        ArrayList itemOutputs = Lists.newArrayList();
        itemInputs.add(ConfigurableItemStack.lockedInputSlot((Item)Items.BLAZE_POWDER));
        for (i = 0; i < 9; ++i) {
            itemInputs.add(ConfigurableItemStack.standardInputSlot());
        }
        for (i = 0; i < 4; ++i) {
            itemInputs.add(ConfigurableItemStack.standardInputSlot());
        }
        for (i = 0; i < 9; ++i) {
            itemOutputs.add(new PotionConfigurableItemStack());
        }
        SlotPositions itemPositions = new SlotPositions.Builder().addSlot(8, 27).addSlots(8, 47, 3, 3).addSlots(53, 27, 4, 1).addSlots(116, 47, 3, 3).build();
        PotionCrafterComponent.SlotRange<ConfigurableItemStack> slotsBlazePowder = PotionCrafterComponent.SlotRange.item(0);
        PotionCrafterComponent.SlotRange<ConfigurableItemStack> slotsBottle = PotionCrafterComponent.SlotRange.item(1, 9);
        PotionCrafterComponent.SlotRange<ConfigurableItemStack> slotsReagent = PotionCrafterComponent.SlotRange.item(10, 13);
        PotionCrafterComponent.SlotRange<ConfigurableItemStack> slotsOutput = PotionCrafterComponent.SlotRange.item(0, 8);
        List<ConfigurableFluidStack> fluidInputs = List.of(ConfigurableFluidStack.lockedInputSlot((long)this.capacity, (Fluid)Fluids.WATER));
        SlotPositions fluidPositions = new SlotPositions.Builder().addSlot(26, 27).build();
        PotionCrafterComponent.SlotRange<ConfigurableFluidStack> slotsWater = PotionCrafterComponent.SlotRange.fluid(0);
        return Pair.of((Object)new MachineInventoryComponent((List)itemInputs, (List)itemOutputs, fluidInputs, List.of(), itemPositions, fluidPositions), (Object)new PotionCrafterComponent.Params(slotsBlazePowder, slotsBottle, slotsReagent, slotsOutput, slotsWater));
    }

    public boolean isEnabled() {
        return this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this);
    }

    public long consumeEu(long max, Simulation simulation) {
        return this.energy.consumeEu(max, simulation);
    }

    @Override
    public long getBaseMaxRecipeEu() {
        return (long)this.tier.getMaxEu() + this.upgrades.getAddMaxEUPerTick();
    }

    public EnergyAccess getEnergyComponent() {
        return this.energy;
    }

    protected InteractionResult onUse(Player player, InteractionHand hand, Direction face) {
        InteractionResult result = super.onUse(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.casing.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.upgrades.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = ModularLubricantHelper.onUse((ModularCrafterAccess)this.crafter, (Player)player, (InteractionHand)hand);
        }
        return result;
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> ((ElectricBreweryMachineBlockEntity)be).insertable));
    }
}

