/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentities.brewery;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.OverclockComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.GunpowderOverclockGui;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.swedz.extended_industrialization.machines.blockentities.brewery.BreweryMachineBlockEntity;
import net.swedz.extended_industrialization.machines.blockentities.brewery.PotionConfigurableItemStack;
import net.swedz.extended_industrialization.machines.components.craft.potion.PotionCrafterComponent;

public final class SteamBreweryMachineBlockEntity
extends BreweryMachineBlockEntity {
    private final OverclockComponent overclockComponent = new OverclockComponent(OverclockComponent.getDefaultCatalysts());

    public SteamBreweryMachineBlockEntity(BEP bep, boolean bronze) {
        super(bep, (bronze ? "bronze" : "steel") + "_brewery", bronze ? MachineTier.BRONZE : MachineTier.STEEL, (bronze ? 8 : 16) * 1000);
        GunpowderOverclockGui.Parameters gunpowderOverclockGuiParams = new GunpowderOverclockGui.Parameters(78, 83);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new GunpowderOverclockGui.Server(gunpowderOverclockGuiParams, () -> ((OverclockComponent)this.overclockComponent).getTicks());
        this.registerGuiComponent(serverArray);
        this.registerComponents(new IComponent[]{this.overclockComponent});
    }

    @Override
    protected Pair<MachineInventoryComponent, PotionCrafterComponent.Params> buildInventory() {
        int i;
        ArrayList itemInputs = Lists.newArrayList();
        ArrayList itemOutputs = Lists.newArrayList();
        itemInputs.add(ConfigurableItemStack.lockedInputSlot((Item)Items.BLAZE_POWDER));
        for (i = 0; i < 9; ++i) {
            itemInputs.add(ConfigurableItemStack.standardInputSlot());
        }
        itemInputs.add(ConfigurableItemStack.standardInputSlot());
        for (i = 0; i < 9; ++i) {
            itemOutputs.add(new PotionConfigurableItemStack());
        }
        SlotPositions itemPositions = new SlotPositions.Builder().addSlot(8, 27).addSlots(8, 47, 3, 3).addSlot(80, 27).addSlots(116, 47, 3, 3).build();
        PotionCrafterComponent.SlotRange<ConfigurableItemStack> slotsBlazePowder = PotionCrafterComponent.SlotRange.item(0);
        PotionCrafterComponent.SlotRange<ConfigurableItemStack> slotsBottle = PotionCrafterComponent.SlotRange.item(1, 9);
        PotionCrafterComponent.SlotRange<ConfigurableItemStack> slotsReagent = PotionCrafterComponent.SlotRange.item(10);
        PotionCrafterComponent.SlotRange<ConfigurableItemStack> slotsOutput = PotionCrafterComponent.SlotRange.item(0, 8);
        List<ConfigurableFluidStack> fluidInputs = Arrays.asList(ConfigurableFluidStack.lockedInputSlot((long)this.capacity, (Fluid)MIFluids.STEAM.asFluid()), ConfigurableFluidStack.lockedInputSlot((long)this.capacity, (Fluid)Fluids.WATER));
        SlotPositions fluidPositions = new SlotPositions.Builder().addSlot(143, 27).addSlot(26, 27).build();
        PotionCrafterComponent.SlotRange<ConfigurableFluidStack> slotsWater = PotionCrafterComponent.SlotRange.fluid(1);
        return Pair.of((Object)new MachineInventoryComponent((List)itemInputs, (List)itemOutputs, fluidInputs, List.of(), itemPositions, fluidPositions), (Object)new PotionCrafterComponent.Params(slotsBlazePowder, slotsBottle, slotsReagent, slotsOutput, slotsWater));
    }

    public long consumeEu(long max, Simulation simulation) {
        return SteamHelper.consumeSteamEu((List)this.inventory.getFluidInputs(), (long)max, (Simulation)simulation);
    }

    @Override
    public long getBaseMaxRecipeEu() {
        return this.overclockComponent.getRecipeEu(this.tier.getMaxEu());
    }

    @Override
    public long getBaseRecipeEu() {
        return this.overclockComponent.getRecipeEu(this.tier.getBaseEu());
    }

    @Override
    public List<Component> getTooltips() {
        return this.overclockComponent.getTooltips();
    }

    @Override
    public void tick() {
        super.tick();
        this.overclockComponent.tick((MachineBlockEntity)this);
    }

    protected InteractionResult onUse(Player player, InteractionHand hand, Direction face) {
        InteractionResult result = super.onUse(player, hand, face);
        if (!result.consumesAction()) {
            return this.overclockComponent.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }
}

