/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentities.multiblock;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.machines.components.craft.processingarray.ProcessingArrayMachineComponent;
import net.swedz.extended_industrialization.machines.guicomponents.processingarraymachineslot.ProcessingArrayMachineSlot;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformer;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformers;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied.AbstractElectricMultipliedCraftingMultiblockBlockEntity;
import net.swedz.tesseract.neoforge.compat.mi.machine.multiblock.members.PredicateSimpleMember;

public final class ProcessingArrayBlockEntity
extends AbstractElectricMultipliedCraftingMultiblockBlockEntity {
    private final ProcessingArrayMachineComponent machines = new ProcessingArrayMachineComponent();
    private static final int MAX_MACHINES = 64;
    private static final int SPLIT = 4;
    private static final int BASE_MACHINES = 8;
    private static final int MULT_MACHINES = 2;
    private static final ShapeTemplate[] SHAPE_TEMPLATES = new ShapeTemplate[4];

    public ProcessingArrayBlockEntity(BEP bep) {
        super(bep, "processing_array", SHAPE_TEMPLATES, MachineTier.LV);
        this.registerComponents(new IComponent[]{this.machines});
        this.registerGuiComponent(new GuiComponent.Server[]{new ProcessingArrayMachineSlot.Server((MachineBlockEntity)this, () -> this.getMachineStackSize(this.activeShape.getActiveShapeIndex()), this.machines)});
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        ShapeSelection.LineInfo[] lineInfoArray = new ShapeSelection.LineInfo[1];
        lineInfoArray[0] = new ShapeSelection.LineInfo(4, IntStream.range(0, 4).map(this::getMachineStackSize).mapToObj(xva$0 -> EIText.PROCESSING_ARRAY_SIZE.text(xva$0)).toList(), false);
        serverArray[0] = new ShapeSelection.Server(new ShapeSelection.Behavior(){

            public void handleClick(int line, int delta) {
                int newShapeIndex = Mth.clamp((int)(ProcessingArrayBlockEntity.this.activeShape.getActiveShapeIndex() + delta), (int)0, (int)(SHAPE_TEMPLATES.length - 1));
                int newMachineStackSize = ProcessingArrayBlockEntity.this.getMachineStackSize(newShapeIndex);
                if (newMachineStackSize < ProcessingArrayBlockEntity.this.machines.getMachines().getCount()) {
                    return;
                }
                ProcessingArrayBlockEntity.this.activeShape.incrementShape((MultiblockMachineBlockEntity)ProcessingArrayBlockEntity.this, delta);
            }

            public int getCurrentIndex(int line) {
                return ProcessingArrayBlockEntity.this.activeShape.getActiveShapeIndex();
            }
        }, lineInfoArray);
        this.registerGuiComponent(serverArray);
    }

    public MachineRecipeType getRecipeType() {
        return this.machines.getMachineRecipeType();
    }

    public int getMaxMultiplier() {
        return this.machines.getMachineCount();
    }

    public EuCostTransformer getEuCostTransformer() {
        return EuCostTransformers.FULL_COST;
    }

    private int getMachineStackSize(int sizeIndex) {
        return (int)(8.0 * Math.pow(2.0, sizeIndex));
    }

    public List<Component> getTooltips() {
        return List.of(MITooltips.DEFAULT_PARSER.parse((Object)EIText.PROCESSING_ARRAY_RECIPE.text()), MITooltips.DEFAULT_PARSER.parse((Object)EIText.PROCESSING_ARRAY_BATCH_SIZE.text()));
    }

    public static void registerReiShapes() {
        for (ShapeTemplate shapeTemplate : SHAPE_TEMPLATES) {
            ReiMachineRecipes.registerMultiblockShape((String)"processing_array", (ShapeTemplate)shapeTemplate);
        }
    }

    static {
        SimpleMember casing = SimpleMember.forBlock((Supplier)((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id((String)"clean_stainless_steel_machine_casing"))));
        SimpleMember pipe = SimpleMember.forBlock((Supplier)((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id((String)"stainless_steel_machine_casing_pipe"))));
        PredicateSimpleMember glass = new PredicateSimpleMember(state -> state.is(EITags.blockForge("glass")), Blocks.GLASS);
        HatchFlags front = new HatchFlags.Builder().with(HatchType.ENERGY_INPUT).build();
        HatchFlags top = new HatchFlags.Builder().with(new HatchType[]{HatchType.ITEM_INPUT, HatchType.FLUID_INPUT}).build();
        HatchFlags bottom = new HatchFlags.Builder().with(new HatchType[]{HatchType.ITEM_OUTPUT, HatchType.FLUID_OUTPUT}).build();
        int i = 0;
        int size = 3;
        for (int machines = 8; i < 4 && machines <= 64; machines *= 2) {
            ShapeTemplate.Builder builder = new ShapeTemplate.Builder(MachineCasings.CLEAN_STAINLESS_STEEL);
            for (int z = 0; z < size; ++z) {
                boolean isFront = z == 0;
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        boolean isGlass;
                        boolean isTop = y == 1;
                        boolean isBottom = y == -1;
                        boolean isCenter = x == 0 && y == 0;
                        boolean bl = isGlass = x != 0 && y == 0;
                        builder.add(x, y, z, (SimpleMember)(isCenter ? pipe : (isGlass ? glass : casing)), (HatchFlags)(isFront ? front : (isTop ? top : (isBottom ? bottom : null))));
                    }
                }
            }
            ProcessingArrayBlockEntity.SHAPE_TEMPLATES[i] = builder.build();
            ++i;
            size += 2;
        }
    }
}

