/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentities.multiblock.farmer;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.swedz.extended_industrialization.EIMachines;
import net.swedz.extended_industrialization.machines.blockentities.multiblock.farmer.FarmerBlockEntity;
import net.swedz.extended_industrialization.machines.components.farmer.PlantingMode;
import net.swedz.extended_industrialization.machines.components.farmer.task.FarmerProcessRates;
import net.swedz.extended_industrialization.machines.components.farmer.task.FarmerTaskType;

public final class ElectricFarmerBlockEntity
extends FarmerBlockEntity
implements EnergyListComponentHolder {
    private static final FarmerBlockEntity.ShapeWrapper SHAPES = new FarmerBlockEntity.ShapeWrapper(4).withCasing(SimpleMember.forBlock((Supplier)((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id((String)"steel_machine_casing")))), SimpleMember.forBlock((Supplier)((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id((String)"steel_machine_casing_pipe")))), EIMachines.Casings.STEEL_PIPE).withElectric().complete();
    private static final FarmerProcessRates PROCESS_RATES = new FarmerProcessRates().with(FarmerTaskType.TILLING, 1, 1).with(FarmerTaskType.HYDRATING, 1, 1).with(FarmerTaskType.FERTLIZING, 1, 1).with(FarmerTaskType.HARVESTING, Integer.MAX_VALUE, 5).with(FarmerTaskType.PLANTING, 1, 5);
    private final RedstoneControlComponent redstoneControl;
    private final List<EnergyComponent> energyInputs = Lists.newArrayList();

    public ElectricFarmerBlockEntity(BEP bep) {
        super(bep, "electric_farmer", 16L, PlantingMode.ALTERNATING_LINES, true, PROCESS_RATES, SHAPES);
        this.redstoneControl = new RedstoneControlComponent();
        this.registerComponents(new IComponent[]{this.redstoneControl});
        this.registerGuiComponent(new GuiComponent.Server[]{new SlotPanel.Server((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl)});
    }

    public static void registerReiShapes() {
        for (ShapeTemplate shapeTemplate : SHAPES.shapeTemplates()) {
            ReiMachineRecipes.registerMultiblockShape((String)"electric_farmer", (ShapeTemplate)shapeTemplate);
        }
    }

    @Override
    public long consumeEu(long max) {
        long total = 0L;
        for (EnergyComponent energyComponent : this.energyInputs) {
            total += energyComponent.consumeEu(max - total, Simulation.ACT);
        }
        return total;
    }

    public List<? extends EnergyAccess> getEnergyComponents() {
        return this.energyInputs;
    }

    @Override
    public void onSuccessfulMatch(ShapeMatcher shapeMatcher) {
        super.onSuccessfulMatch(shapeMatcher);
        this.energyInputs.clear();
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            hatch.appendEnergyInputs(this.energyInputs);
        }
    }

    protected InteractionResult onUse(Player player, InteractionHand hand, Direction face) {
        InteractionResult result = super.onUse(player, hand, face);
        if (!result.consumesAction()) {
            result = (InteractionResult)this.mapComponentOrDefault(UpgradeComponent.class, upgrade -> upgrade.onUse((MachineBlockEntity)this, player, hand), result);
        }
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this);
    }
}

