/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.swedz.extended_industrialization.EIBlocks;
import net.swedz.extended_industrialization.EILocalizedListeners;
import net.swedz.extended_industrialization.machines.blockentities.MachineChainerMachineBlockEntity;
import net.swedz.tesseract.neoforge.localizedlistener.LocalizedListener;

public final class MachineChainerComponent
implements IComponent.ServerOnly {
    private final MachineChainerMachineBlockEntity machineBlockEntity;
    private final int maxConnectedMachines;
    private final LocalizedListener<BlockEvent.NeighborNotifyEvent> listenerNeighborNotify;
    private List<BlockPos> machineLinks = Lists.newArrayList();
    private List<StorageWrapper<IItemHandler>> machineItemWrappers = Lists.newArrayList();
    private List<StorageWrapper<IFluidHandler>> machineFluidWrappers = Lists.newArrayList();
    private List<StorageWrapper<MIEnergyStorage>> machineEnergyWrappers = Lists.newArrayList();
    private int machineItemSlots;
    private int machineFluidSlots;
    public final ItemHandler itemHandler = new ItemHandler();
    public final FluidHandler fluidHandler = new FluidHandler();
    public final EnergyHandler energyHandler = new EnergyHandler();
    private int tick;
    private Set<ChunkPos> previousSpannedChunks = Sets.newHashSet();

    public MachineChainerComponent(MachineChainerMachineBlockEntity machineBlockEntity, int maxConnectedMachines) {
        this.machineBlockEntity = machineBlockEntity;
        this.maxConnectedMachines = maxConnectedMachines;
        this.listenerNeighborNotify = event -> {
            if (this.machineLinks.contains(event.getPos()) || event.getPos().equals((Object)machineBlockEntity.getBlockPos().relative(machineBlockEntity.orientation.facingDirection, this.machineLinks.size() + 1))) {
                this.buildLinks();
            }
        };
    }

    public Level getLevel() {
        return this.machineBlockEntity.getLevel();
    }

    public int getMaxConnectedMachinesCount() {
        return this.maxConnectedMachines;
    }

    public int getConnectedMachineCount() {
        return this.machineLinks.size();
    }

    private boolean containsMachineAt(BlockPos blockPos, boolean includeChainerChildren) {
        if (this.machineLinks.contains(blockPos)) {
            return true;
        }
        if (includeChainerChildren) {
            for (BlockPos link : this.machineLinks) {
                MachineChainerMachineBlockEntity chainerBlockEntity;
                BlockEntity blockEntity = this.getLevel().getBlockEntity(link);
                if (!(blockEntity instanceof MachineChainerMachineBlockEntity) || !(chainerBlockEntity = (MachineChainerMachineBlockEntity)blockEntity).getChainerComponent().containsMachineAt(blockPos, true)) continue;
                return true;
            }
        }
        return false;
    }

    private List<BlockPos> getSpannedBlocks() {
        ArrayList blocks = Lists.newArrayList();
        for (int i = 1; i <= this.maxConnectedMachines; ++i) {
            blocks.add(this.machineBlockEntity.getBlockPos().relative(this.machineBlockEntity.orientation.facingDirection, i));
        }
        return Collections.unmodifiableList(blocks);
    }

    private Set<ChunkPos> getSpannedChunks() {
        HashSet chunks = Sets.newHashSet();
        for (BlockPos block : this.getSpannedBlocks()) {
            chunks.add(new ChunkPos(block));
        }
        return Collections.unmodifiableSet(chunks);
    }

    public void registerListeners() {
        if (this.previousSpannedChunks.size() > 0) {
            throw new IllegalStateException("Cannot register listeners for a chainer that already has listeners registered");
        }
        Set<ChunkPos> spannedChunks = this.getSpannedChunks();
        EILocalizedListeners.INSTANCE.register(this.getLevel(), spannedChunks, BlockEvent.NeighborNotifyEvent.class, this.listenerNeighborNotify);
        this.previousSpannedChunks = spannedChunks;
    }

    public void unregisterListeners() {
        if (this.previousSpannedChunks.size() > 0) {
            EILocalizedListeners.INSTANCE.unregister(this.getLevel(), this.previousSpannedChunks, BlockEvent.NeighborNotifyEvent.class, this.listenerNeighborNotify);
            this.previousSpannedChunks = Sets.newHashSet();
        }
    }

    public void clearLinks() {
        this.machineLinks = List.of();
        this.machineItemWrappers = List.of();
        this.machineFluidWrappers = List.of();
        this.machineEnergyWrappers = List.of();
        this.machineItemSlots = 0;
        this.machineFluidSlots = 0;
    }

    public void buildLinks() {
        ArrayList machinesFound = Lists.newArrayList();
        ArrayList itemWrappers = Lists.newArrayList();
        ArrayList fluidWrappers = Lists.newArrayList();
        ArrayList energyWrappers = Lists.newArrayList();
        int itemSlots = 0;
        int fluidSlots = 0;
        for (BlockPos blockPos : this.getSpannedBlocks()) {
            MIEnergyStorage energyStorage;
            IFluidHandler fluidHandler;
            if (this.getLevel().getBlockState(blockPos).is(EIBlocks.MACHINE_CHAINER_RELAY.get())) {
                machinesFound.add(blockPos);
                continue;
            }
            BlockEntity blockEntity = this.getLevel().getBlockEntity(blockPos);
            if (!(blockEntity instanceof MachineBlockEntity)) break;
            if (blockEntity instanceof MachineChainerMachineBlockEntity) {
                MachineChainerMachineBlockEntity chainerBlockEntity = (MachineChainerMachineBlockEntity)blockEntity;
                if (chainerBlockEntity.orientation.facingDirection == this.machineBlockEntity.orientation.facingDirection || chainerBlockEntity.orientation.facingDirection.getOpposite() == this.machineBlockEntity.orientation.facingDirection || chainerBlockEntity.getChainerComponent().containsMachineAt(this.machineBlockEntity.getBlockPos(), true)) break;
            }
            boolean isMachine = false;
            IItemHandler itemHandler = (IItemHandler)this.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, blockPos, null);
            if (itemHandler != null) {
                int itemSlotStart = itemSlots;
                int itemSlotEnd = (itemSlots += itemHandler.getSlots()) - 1;
                itemWrappers.add(new StorageWrapper<IItemHandler>(blockPos, itemHandler, itemSlotStart, itemSlotEnd));
                isMachine = true;
            }
            if ((fluidHandler = (IFluidHandler)this.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, blockPos, null)) != null) {
                int fluidSlotStart = fluidSlots;
                int fluidSlotEnd = (fluidSlots += fluidHandler.getTanks()) - 1;
                fluidWrappers.add(new StorageWrapper<IFluidHandler>(blockPos, fluidHandler, fluidSlotStart, fluidSlotEnd));
                isMachine = true;
            }
            if ((energyStorage = (MIEnergyStorage)this.getLevel().getCapability(EnergyApi.SIDED, blockPos, null)) != null) {
                energyWrappers.add(new StorageWrapper<MIEnergyStorage>(blockPos, energyStorage, -1, -1));
                isMachine = true;
            }
            if (!isMachine) break;
            machinesFound.add(blockPos);
        }
        this.machineLinks = Collections.unmodifiableList(machinesFound);
        this.machineItemWrappers = Collections.unmodifiableList(itemWrappers);
        this.machineFluidWrappers = Collections.unmodifiableList(fluidWrappers);
        this.machineEnergyWrappers = Collections.unmodifiableList(energyWrappers);
        this.machineItemSlots = itemSlots;
        this.machineFluidSlots = fluidSlots;
    }

    private <T> StorageWrapper<T> getStorageFromSlot(int slot, List<StorageWrapper<T>> storages) {
        if (slot < 0) {
            return null;
        }
        for (StorageWrapper<T> storage : storages) {
            if (!storage.contains(slot)) continue;
            return storage;
        }
        return null;
    }

    public void writeNbt(CompoundTag tag) {
    }

    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
    }

    private final class ItemHandler
    implements IItemHandler {
        private ItemHandler() {
        }

        public int getSlots() {
            return MachineChainerComponent.this.machineItemSlots;
        }

        public ItemStack getStackInSlot(int slot) {
            StorageWrapper wrapper = MachineChainerComponent.this.getStorageFromSlot(slot, MachineChainerComponent.this.machineItemWrappers);
            return wrapper == null ? ItemStack.EMPTY : ((IItemHandler)wrapper.handler()).getStackInSlot(wrapper.getHandlerSlot(slot));
        }

        public ItemStack insertItem(int __, ItemStack stack, boolean simulate) {
            ArrayList<StorageWrapper<IItemHandler>> storagesShuffled = new ArrayList<StorageWrapper<IItemHandler>>(MachineChainerComponent.this.machineItemWrappers);
            Collections.shuffle(storagesShuffled);
            ItemStack remaining = stack;
            for (StorageWrapper storageWrapper : storagesShuffled) {
                for (int slot = 0; slot < ((IItemHandler)storageWrapper.handler()).getSlots(); ++slot) {
                    remaining = ((IItemHandler)storageWrapper.handler()).insertItem(slot, remaining, simulate);
                    if (!remaining.isEmpty()) continue;
                    return remaining;
                }
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            StorageWrapper wrapper = MachineChainerComponent.this.getStorageFromSlot(slot, MachineChainerComponent.this.machineItemWrappers);
            return wrapper == null ? ItemStack.EMPTY : ((IItemHandler)wrapper.handler()).extractItem(wrapper.getHandlerSlot(slot), amount, simulate);
        }

        public int getSlotLimit(int slot) {
            StorageWrapper wrapper = MachineChainerComponent.this.getStorageFromSlot(slot, MachineChainerComponent.this.machineItemWrappers);
            return wrapper == null ? 0 : ((IItemHandler)wrapper.handler()).getSlotLimit(wrapper.getHandlerSlot(slot));
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            StorageWrapper wrapper = MachineChainerComponent.this.getStorageFromSlot(slot, MachineChainerComponent.this.machineItemWrappers);
            return wrapper != null && ((IItemHandler)wrapper.handler()).isItemValid(wrapper.getHandlerSlot(slot), stack);
        }
    }

    private final class FluidHandler
    implements IFluidHandler {
        private FluidHandler() {
        }

        public int getTanks() {
            return MachineChainerComponent.this.machineFluidSlots;
        }

        public FluidStack getFluidInTank(int tank) {
            StorageWrapper wrapper = MachineChainerComponent.this.getStorageFromSlot(tank, MachineChainerComponent.this.machineFluidWrappers);
            return wrapper == null ? FluidStack.EMPTY : ((IFluidHandler)wrapper.handler()).getFluidInTank(wrapper.getHandlerSlot(tank));
        }

        public int getTankCapacity(int tank) {
            StorageWrapper wrapper = MachineChainerComponent.this.getStorageFromSlot(tank, MachineChainerComponent.this.machineFluidWrappers);
            return wrapper == null ? 0 : ((IFluidHandler)wrapper.handler()).getTankCapacity(wrapper.getHandlerSlot(tank));
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            StorageWrapper wrapper = MachineChainerComponent.this.getStorageFromSlot(tank, MachineChainerComponent.this.machineFluidWrappers);
            return wrapper != null && ((IFluidHandler)wrapper.handler()).isFluidValid(wrapper.getHandlerSlot(tank), stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int amountFilled = 0;
            for (int i = 0; i < MachineChainerComponent.this.machineFluidWrappers.size(); ++i) {
                StorageWrapper<IFluidHandler> wrapper = MachineChainerComponent.this.machineFluidWrappers.get(i);
                int remainingStorages = MachineChainerComponent.this.machineFluidWrappers.size() - i;
                int remainingAmountToInsert = resource.getAmount() - amountFilled;
                int amountToInsert = remainingAmountToInsert / remainingStorages;
                amountFilled += wrapper.handler().fill(resource.copyWithAmount(amountToInsert), action);
            }
            return amountFilled;
        }

        private FluidStack drain(Fluid fluid, int maxAmount, IFluidHandler.FluidAction action) {
            int amountTransferred = 0;
            for (int i = 0; i < MachineChainerComponent.this.machineFluidWrappers.size(); ++i) {
                FluidStack transferred;
                StorageWrapper<IFluidHandler> wrapper = MachineChainerComponent.this.machineFluidWrappers.get(i);
                int remainingStorages = MachineChainerComponent.this.machineFluidWrappers.size() - i;
                int remainingAmountToTransfer = maxAmount - amountTransferred;
                int amountToTansfer = remainingAmountToTransfer / remainingStorages;
                FluidStack fluidStack = transferred = fluid == null ? wrapper.handler().drain(amountToTansfer, action) : wrapper.handler().drain(new FluidStack(fluid, amountToTansfer), action);
                if (transferred.isEmpty()) continue;
                fluid = transferred.getFluid();
                amountTransferred += transferred.getAmount();
            }
            return fluid == null ? FluidStack.EMPTY : new FluidStack(fluid, amountTransferred);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.drain(resource.getFluid(), resource.getAmount(), action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.drain(null, maxDrain, action);
        }
    }

    private final class EnergyHandler
    implements MIEnergyStorage {
        private EnergyHandler() {
        }

        public boolean canConnect(CableTier cableTier) {
            return true;
        }

        public long getAmount() {
            return MachineChainerComponent.this.machineEnergyWrappers.stream().mapToLong(wrapper -> ((MIEnergyStorage)wrapper.handler()).getAmount()).sum();
        }

        public long getCapacity() {
            return MachineChainerComponent.this.machineEnergyWrappers.stream().mapToLong(wrapper -> ((MIEnergyStorage)wrapper.handler()).getCapacity()).sum();
        }

        public boolean canReceive() {
            return true;
        }

        public long receive(long maxReceive, boolean simulate) {
            long amountReceived = 0L;
            for (int i = 0; i < MachineChainerComponent.this.machineEnergyWrappers.size(); ++i) {
                StorageWrapper<MIEnergyStorage> wrapper = MachineChainerComponent.this.machineEnergyWrappers.get(i);
                int remainingStorages = MachineChainerComponent.this.machineEnergyWrappers.size() - i;
                long remainingAmountToReceive = maxReceive - amountReceived;
                long amountToReceive = remainingAmountToReceive / (long)remainingStorages;
                amountReceived += wrapper.handler().receive(amountToReceive, simulate);
            }
            return amountReceived;
        }

        public boolean canExtract() {
            return false;
        }

        public long extract(long maxExtract, boolean simulate) {
            return 0L;
        }
    }

    private record StorageWrapper<H>(BlockPos blockPos, H handler, int slotStart, int slotEnd) {
        public boolean contains(int slot) {
            return slot >= this.slotStart && slot <= this.slotEnd;
        }

        public int getHandlerSlot(int slot) {
            return slot - this.slotStart;
        }
    }
}

